% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_contrast.R
\name{build_contrast}
\alias{build_contrast}
\title{Builds a contrast code from character vector}
\usage{
build_contrast(vector, cond_a, cond_b)
}
\arguments{
\item{vector}{A character vector.}

\item{cond_a}{A character string to be coded -0.5.}

\item{cond_b}{A character string to be coded  0.5.}
}
\value{
A numeric vector.
}
\description{
This function constructs a contrast code from a character
variable. It is useful when one needs to recode a two-category character
variable to a numeric one.
}
\details{
The \code{\link{lm}} method supports factor and character variables
by dummy coding them. Dummy coding can make the interpretation of regression
coefficient difficult or at least more difficult than contrast coding.
Contrast-coded-variable coefficients interpretation is particularly useful
when conducting a joint-significance test.
}
\examples{
  data(ho_et_al)

  ho_et_al$condition_contrast <- build_contrast(ho_et_al$condition,
                                                "Low discrimination",
                                                "High discrimination")

 head(ho_et_al)

}
\seealso{
\code{\link{scale}} for centering continuous numeric variable.
}
