/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.robjects;

public class RObject {
    private String name = null;
    private String type = null;
    private RObject parent = null;
    private String info = null;
    private boolean realName = false;

    public RObject(String name, String type, RObject parent, boolean b) {
        this.name = name;
        this.type = type;
        this.parent = parent;
        this.realName = b;
    }

    public RObject(String name, String type, boolean b) {
        this(name, type, null, b);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public RObject getParent() {
        return this.parent;
    }

    public void setParent(RObject p) {
        this.parent = p;
    }

    public boolean isAtomar() {
        return this.type.indexOf("function") >= 0 || this.type.indexOf("integer") >= 0 || this.type.indexOf("numeric") >= 0 || this.type.indexOf("character") >= 0 || this.type.indexOf("logical") >= 0 || this.type.indexOf("factor") >= 0 || this.type.indexOf("environment") >= 0;
    }

    public boolean isEditable() {
        return this.type.indexOf("numeric") >= 0 || this.type.indexOf("integer") >= 0 || this.type.indexOf("factor") >= 0 || this.type.indexOf("character") >= 0 || this.type.indexOf("data.frame") >= 0 || this.type.indexOf("matrix") >= 0 || this.type.indexOf("list") >= 0;
    }

    public String getRName() {
        if (this.parent != null && this.parent.getType().equals("matrix")) {
            return this.parent.getName() + "[," + (this.realName ? "\"" : "") + this.getName() + (this.realName ? "\"" : "") + "]";
        }
        if (this.parent != null && this.parent.getType().equals("table")) {
            return "dimnames(" + this.parent.getRName() + ")[[" + (this.realName ? "\"" : "") + this.getName() + (this.realName ? "\"" : "") + "]]";
        }
        return this.parent == null ? this.getName() : this.parent.getRName() + "[[" + (this.realName ? "\"" : "") + this.getName() + (this.realName ? "\"" : "") + "]]";
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String s) {
        this.info = s;
    }

    public String toString() {
        return this.name + "\t (" + this.type + ") " + (this.info != null ? this.info : "");
    }
}

