/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.browser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.browser.BrowserNode;
import org.rosuda.JGR.browser.DefaultBrowserNode;
import org.rosuda.JGR.robjects.RObject;
import org.rosuda.JGR.toolkit.DataTable;
import org.rosuda.ibase.SVarSet;

public class FactorNode
extends DefaultBrowserNode {
    public FactorNode() {
    }

    public FactorNode(BrowserNode parent, String rName, String rClass) {
        super(parent, rName, rClass);
    }

    public BrowserNode generate(BrowserNode parent, String rName, String rClass) {
        return new FactorNode(parent, rName, rClass);
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        DefaultBrowserNode.PopupListener lis = new DefaultBrowserNode.PopupListener();
        JMenuItem item = new JMenuItem("Edit");
        item.addActionListener(lis);
        menu.add(item);
        JMenu convertMenu = new JMenu("Convert");
        ActionListener convertListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                JGR.MAINRCONSOLE.execute(FactorNode.this.getExecuteableRObjectName() + " <- as." + cmd + "(" + FactorNode.this.getExecuteableRObjectName() + ")");
            }
        };
        item = new JMenuItem("character");
        item.addActionListener(convertListener);
        convertMenu.add(item);
        item = new JMenuItem("factor");
        item.addActionListener(convertListener);
        convertMenu.add(item);
        item = new JMenuItem("integer");
        item.addActionListener(convertListener);
        convertMenu.add(item);
        item = new JMenuItem("numeric");
        item.addActionListener(convertListener);
        convertMenu.add(item);
        menu.add(convertMenu);
        menu.add(new JSeparator());
        item = new JMenuItem("Print");
        item.addActionListener(lis);
        menu.add(item);
        item = new JMenuItem("Summary");
        item.addActionListener(lis);
        menu.add(item);
        item = new JMenuItem("Plot");
        item.addActionListener(lis);
        menu.add(item);
        menu.add(new JSeparator());
        item = new JMenuItem("Remove");
        item.addActionListener(lis);
        menu.add(item);
        return menu;
    }

    public void editObject() {
        new Thread(new Runnable(){

            public void run() {
                final RObject o = new RObject(FactorNode.this.getExecuteableRObjectName(), FactorNode.this.cls, true);
                final SVarSet vs = RController.newSet(o);
                if (vs != null && vs.count() != 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            new DataTable(vs, o.getType(), o.isEditable());
                        }
                    });
                }
            }
        }).start();
    }

    public void plotObject() {
        JGR.MAINRCONSOLE.execute("barchart(" + this.getExecuteableRObjectName() + ")");
    }
}

