/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.Vector;
import org.rosuda.ibase.toolkit.WTentry;
import org.rosuda.util.Global;

public class WinTracker
implements ActionListener,
FocusListener {
    public static WinTracker current = null;
    Vector wins = new Vector();
    WTentry curFocus = null;

    void newWindowMenu(WTentry we) {
        we.addMenuItem("@WClose window", "WTMclose" + we.id);
        we.addMenuItem("!WClose same type", "WTMcloseClass" + we.wclass);
        we.addMenuItem("Close all", "WTMcloseAll");
        we.addMenuSeparator();
        Enumeration e = this.wins.elements();
        while (e.hasMoreElements()) {
            WTentry we2 = (WTentry)e.nextElement();
            if (we2 == null || we2 == we) continue;
            we2.addWindowMenuEntry(we);
        }
    }

    public void add(WTentry we) {
        if (we == null) {
            return;
        }
        this.wins.addElement(we);
        Enumeration e = this.wins.elements();
        while (e.hasMoreElements()) {
            WTentry we2 = (WTentry)e.nextElement();
            if (Global.DEBUG > 0) {
                System.out.println("-- updating menu; we2=" + we2.toString());
            }
            if (we2 == null) continue;
            we.addWindowMenuEntry(we2);
            if (Global.DEBUG <= 0) continue;
            System.out.println("-- menu updated");
        }
        if (we.w != null) {
            we.w.addFocusListener(this);
        }
        if (Global.DEBUG > 0) {
            System.out.println(">>new window: \"" + we.name + "\" (" + we.w.toString() + ")");
        }
    }

    public boolean contains(int wclass) {
        Enumeration e = this.wins.elements();
        while (e.hasMoreElements()) {
            WTentry we = (WTentry)e.nextElement();
            if (we.wclass != wclass || we.w == null) continue;
            we.w.requestFocus();
            we.w.toFront();
            try {
                Frame f = (Frame)we.w;
                f.setState(0);
            }
            catch (Exception ex) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public void disableAll() {
        Enumeration e = this.wins.elements();
        while (e.hasMoreElements()) {
            ((WTentry)e.nextElement()).w.setFocusableWindowState(false);
        }
    }

    public void enableAll() {
        Enumeration e = this.wins.elements();
        while (e.hasMoreElements()) {
            ((WTentry)e.nextElement()).w.setFocusableWindowState(true);
        }
    }

    public void rm(WTentry we) {
        if (we == null) {
            return;
        }
        this.wins.removeElement(we);
        Enumeration e = this.wins.elements();
        while (e.hasMoreElements()) {
            WTentry we2 = (WTentry)e.nextElement();
            if (we2 == null) continue;
            we.rmWindowMenuEntry(we2);
        }
        if (Global.DEBUG > 0) {
            System.out.println(">>window removed: \"" + we.name + "\"");
        }
        if (this.wins.size() == 0 && Global.AppType == 0) {
            System.out.println("FATAL: Stand-alone mode, last window closed, but no splash screen present. Assuming exit request.");
            System.exit(0);
        }
    }

    public void rm(Window w) {
        if (Global.DEBUG > 0) {
            System.out.println(">>request to remove window \"" + w.toString() + "\"");
        }
        Enumeration e = this.wins.elements();
        while (e.hasMoreElements()) {
            WTentry we = (WTentry)e.nextElement();
            if (Global.DEBUG > 0) {
                System.out.println("-- lookup: " + (we == null ? "<null>" : we.toString()));
            }
            if (we == null || we.w != w) continue;
            if (Global.DEBUG > 0) {
                System.out.println("-- matches");
            }
            this.rm(we);
            return;
        }
    }

    public Object getWindowMenu(Window w) {
        WTentry we = this.getEntry(w);
        System.out.println(we.toString());
        return we == null ? null : we.getWindowMenu();
    }

    public Enumeration elements() {
        return this.wins.elements();
    }

    public WTentry getEntry(int id) {
        Enumeration e = this.wins.elements();
        while (e.hasMoreElements()) {
            WTentry we = (WTentry)e.nextElement();
            if (we == null || we.id != id) continue;
            return we;
        }
        return null;
    }

    public WTentry getEntry(Window w) {
        Enumeration e = this.wins.elements();
        while (e.hasMoreElements()) {
            WTentry we = (WTentry)e.nextElement();
            if (we == null || we.w != w) continue;
            return we;
        }
        return null;
    }

    public void disposeAll() {
        if (Global.DEBUG > 0) {
            System.out.println(">>dispose all requested");
        }
        Enumeration e = this.wins.elements();
        while (e.hasMoreElements()) {
            WTentry we = (WTentry)e.nextElement();
            if (we == null || we.w == null) continue;
            we.w.dispose();
        }
        this.wins.removeAllElements();
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev == null) {
            return;
        }
        String cmd = ev.getActionCommand();
        Object o = ev.getSource();
        if (Global.DEBUG > 0) {
            System.out.println(">> action: " + cmd + " by " + o.toString());
        }
        Enumeration e = this.wins.elements();
        while (e.hasMoreElements()) {
            WTentry we = (WTentry)e.nextElement();
            if (we != null && (cmd.compareTo("WTMclose" + we.id) == 0 || "WTMcloseAll".equals(cmd) && we.wclass > 8 || cmd.equals("WTMcloseClass" + we.wclass))) {
                if (Global.DEBUG > 0) {
                    System.out.println(">>close:  (" + we.id + ")");
                }
                if (we.w != null) {
                    we.w.dispose();
                }
            }
            if (we == null || cmd.compareTo("WTMwindow" + we.id) != 0) continue;
            if (Global.DEBUG > 0) {
                System.out.println(">>activate: \"" + we.name + "\" (" + we.w.toString() + ")");
            }
            if (we.w == null) continue;
            we.w.requestFocus();
            we.w.toFront();
            try {
                Frame f = (Frame)we.w;
                f.setState(0);
            }
            catch (Exception ex) {}
        }
    }

    public void focusGained(FocusEvent ev) {
        Window w = (Window)ev.getSource();
        Enumeration e = this.wins.elements();
        while (e.hasMoreElements()) {
            WTentry we = (WTentry)e.nextElement();
            if (we == null || we.w != w) continue;
            this.curFocus = we;
        }
    }

    public void focusLost(FocusEvent ev) {
        Window w = (Window)ev.getSource();
        Enumeration e = this.wins.elements();
        while (e.hasMoreElements()) {
            WTentry we = (WTentry)e.nextElement();
            if (we == null || we.w != w || this.curFocus != we) continue;
            this.curFocus = null;
        }
    }

    public void Exit() {
        this.disposeAll();
        System.exit(0);
    }
}

