/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.TxtTableLoader;
import org.rosuda.JGR.editor.Editor;
import org.rosuda.JGR.toolkit.ExtensionFileFilter;
import org.rosuda.JGR.toolkit.FileSelector;
import org.rosuda.JGR.util.ErrorMsg;

public class DataLoader
extends JFrame
implements PropertyChangeListener {
    private static final long serialVersionUID = -7945677424441713542L;
    private static String[][] extensions = new String[][]{{"rda", "rdata"}, {"robj"}, {"csv"}, {"txt"}, {"sav"}, {"xpt"}, {"dbf"}, {"dta"}, {"syd", "sys"}, {"arff"}, {"rec"}, {"mtp"}, {"s3"}, {"xls", "xlsx"}};
    private static String[] extensionDescription = new String[]{"R (*.rda *.rdata)", "R dput() (*.robj)", "Comma seperated (*.csv)", "Text file (*.txt)", "SPSS (*.sav)", "SAS export (*.xpt)", "DBase (*.dbf)", "Stata (*.dta)", "Systat (*.sys *.syd)", "ARFF (*.arff)", "Epiinfo (*.rec)", "Minitab (*.mtp)", "S data dump (*.s3)", "Excel (*.xls *.xlsx)"};
    private JTextField rDataNameField;
    private String rName;
    private FileSelector fileDialog;

    public DataLoader() {
        try {
            this.fileDialog = new FileSelector(this, "Load Data", 0, null, true);
            JFileChooser chooser = this.fileDialog.getJFileChooser();
            for (int i = 0; i < extensionDescription.length; ++i) {
                ExtensionFileFilter extFilter = new ExtensionFileFilter(extensionDescription[i], extensions[i]);
                chooser.addChoosableFileFilter(extFilter);
            }
            chooser.setFileFilter(chooser.getAcceptAllFileFilter());
            JPanel namePanel = new JPanel(new FlowLayout(0));
            namePanel.add(new JLabel("Set name: "));
            this.rDataNameField = new JTextField(20);
            namePanel.add(this.rDataNameField);
            this.fileDialog.addFooterPanel(namePanel);
            this.fileDialog.getJFileChooser().addPropertyChangeListener(this);
            this.fileDialog.setVisible(true);
            if (this.fileDialog.getFile() == null) {
                return;
            }
            this.rName = this.rDataNameField.getText();
            if (this.rName.length() == 0) {
                this.rName = this.fileDialog.getFile().indexOf(".") <= 0 ? this.getUniqueName(this.fileDialog.getFile()) : this.getUniqueName(this.fileDialog.getFile().substring(0, this.fileDialog.getFile().indexOf(".")));
            }
            this.rName = RController.makeValidVariableName(this.rName);
            this.loadData(DataLoader.addSlashes(this.fileDialog.getFile()), this.fileDialog.getDirectory(), this.rName);
        }
        catch (Exception er) {
            new ErrorMsg(er);
        }
    }

    private static String addSlashes(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer s = new StringBuffer(str);
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\"') {
                s.insert(i++, '\\');
                continue;
            }
            if (s.charAt(i) != '\'') continue;
            s.insert(i++, '\\');
        }
        return s.toString();
    }

    public void loadData(String fileName, String directory, String var) {
        if (fileName.toLowerCase().endsWith(".rda") || fileName.toLowerCase().endsWith(".rdata")) {
            this.loadRdaFile(fileName, directory);
        } else if (fileName.toLowerCase().endsWith(".robj")) {
            this.loadDputFile(fileName, directory);
        } else if (fileName.toLowerCase().endsWith(".r")) {
            Editor temp = new Editor((directory + fileName).replace('\\', '/'), true);
            temp.dispose();
        } else if (fileName.toLowerCase().endsWith(".txt") | fileName.toLowerCase().endsWith(".csv")) {
            this.loadTxtFile(fileName, directory, var);
        } else {
            try {
                RController.loadPackage("foreign");
                if (fileName.toLowerCase().endsWith(".sav")) {
                    this.execute(var + " <- read.spss('" + (directory + fileName).replace('\\', '/') + "',to.data.frame=TRUE)", true);
                } else if (fileName.toLowerCase().endsWith(".xpt") | fileName.toLowerCase().endsWith(".xport")) {
                    this.execute(var + " <- read.xport('" + directory.replace('\\', '/') + fileName + "')", true);
                } else if (fileName.toLowerCase().endsWith(".dta")) {
                    this.execute(var + " <- read.dta('" + directory.replace('\\', '/') + fileName + "')", true);
                } else if (fileName.toLowerCase().endsWith(".arff")) {
                    this.execute(var + " <- read.arff('" + directory.replace('\\', '/') + fileName + "')", true);
                } else if (fileName.toLowerCase().endsWith(".rec")) {
                    this.execute(var + " <- read.epiinfo('" + directory.replace('\\', '/') + fileName + "')", true);
                } else if (fileName.toLowerCase().endsWith(".mtp")) {
                    this.execute(var + " <- as.data.frame(read.mtp('" + directory.replace('\\', '/') + fileName + "'))", true);
                } else if (fileName.toLowerCase().endsWith(".s3")) {
                    this.execute("data.restore('" + directory.replace('\\', '/') + fileName + "',print=TRUE)", true);
                } else if (fileName.toLowerCase().endsWith(".syd") || fileName.toLowerCase().endsWith(".sys")) {
                    this.execute(var + " <- read.systat('" + directory.replace('\\', '/') + fileName + "')", true);
                } else if (fileName.toLowerCase().endsWith(".dbf")) {
                    this.execute(var + " <- read.dbf('" + directory.replace('\\', '/') + fileName + "')", true);
                } else if (fileName.toLowerCase().endsWith(".xls") || fileName.toLowerCase().endsWith(".xlsx")) {
                    RController.loadPackage("XLConnect");
                    String sheet = JOptionPane.showInputDialog("Which worksheet should be loaded?", (Object)"1");
                    JGR.MAINRCONSOLE.execute("library(XLConnect)\n" + var + " <- readWorksheet(loadWorkbook('" + directory.replace('\\', '/') + fileName + "'),sheet=" + sheet + ")", true);
                } else {
                    int opt = JOptionPane.showConfirmDialog(this, "Unknown File Type.\nWould you like to try to open it as a text data file?");
                    if (opt == 0) {
                        this.loadTxtFile(fileName, directory, var);
                    }
                }
            }
            catch (Exception e) {
                new ErrorMsg(e);
            }
        }
    }

    public void loadRdaFile(String fileName, String directory) {
        String cmd = "print(load(\"" + directory.replace('\\', '/') + fileName + "\"))";
        JGR.threadedEval("cat('The following data objects have been loaded:\\\n')");
        this.execute(cmd, true);
    }

    public void loadDputFile(String fileName, String directory) {
        String var = fileName.indexOf(".") <= 0 ? this.getUniqueName(fileName) : this.getUniqueName(fileName.substring(0, fileName.indexOf(".")));
        this.execute(var + " <- dget('" + (directory + fileName).replace('\\', '/') + "')", true);
    }

    public void loadTxtFile(String fileName, String directory, String rName) {
        TxtTableLoader.run(directory.replace('\\', '/') + fileName, rName);
    }

    public void execute(String cmd, boolean show) {
        JGR.MAINRCONSOLE.execute(cmd, show);
    }

    public String getUniqueName(String name) {
        return JGR.MAINRCONSOLE.getUniqueName(name);
    }

    public String getDataName() {
        return this.rName;
    }

    public void propertyChange(PropertyChangeEvent e) {
        File file = this.fileDialog.getSelectedFile();
        if (e.getPropertyName() == "SelectedFileChangedProperty") {
            if (!(file == null || file.isDirectory() || file.getName().toLowerCase().endsWith(".rdata") || file.getName().toLowerCase().endsWith(".rda"))) {
                String name = file.getName().replaceAll("\\..*", "");
                name = this.getUniqueName(name);
                this.rDataNameField.setText(name);
            } else {
                this.rDataNameField.setText("");
            }
        }
    }
}

