/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.util.Stopwatch;

public class SVarFact
extends SVar {
    public int[] cont;
    int[] temp;
    public String[] cats;
    String[] tempcats;
    int[] ccnts;
    int[] ranks = null;
    boolean lastIsMissing = false;
    public boolean muteNotify = false;

    public boolean isLastMissing() {
        return this.lastIsMissing;
    }

    public SVarFact(String string, int n) {
        super(string, true);
        this.isnum = false;
        this.cont = new int[n];
        for (int i = 0; i < this.cont.length; ++i) {
            this.cont[i] = this.getCatIndex("NA");
        }
        this.cats = new String[0];
    }

    public SVarFact(String string, int[] nArray, String[] stringArray) {
        super(string, true);
        this.isnum = false;
        this.contentsType = 0;
        this.cont = nArray;
        this.cats = stringArray;
        this.ccnts = new int[stringArray.length + 1];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0 && nArray[i] < this.cats.length) {
                int n = nArray[i];
                this.ccnts[n] = this.ccnts[n] + 1;
                continue;
            }
            this.cont[i] = -1;
            ++this.missingCount;
        }
    }

    public void createMissingsCat() {
        if (!this.cat || this.cont == null || this.cont.length < 1 || this.missingCount == 0 || this.isLastMissing()) {
            return;
        }
        int n = 0;
        for (int i = 0; i < this.cont.length; ++i) {
            if (this.cont[i] != -1) continue;
            this.cont[i] = this.cats.length;
            ++n;
        }
        String[] stringArray = new String[this.cats.length + 1];
        System.arraycopy(this.cats, 0, stringArray, 0, this.cats.length);
        stringArray[this.cats.length] = "NA";
        int[] nArray = new int[this.cats.length + 1];
        System.arraycopy(this.ccnts, 0, nArray, 0, this.ccnts.length);
        nArray[this.cats.length] = n;
        this.missingCount = n;
        this.cats = stringArray;
        this.ccnts = nArray;
        this.lastIsMissing = true;
    }

    public void setAllEmpty(int n) {
        this.cont = new int[n];
        for (int i = 0; i < n; ++i) {
            this.cont[i] = -1;
        }
        this.missingCount = n;
    }

    public int size() {
        return this.cont.length;
    }

    public void categorize(boolean bl) {
        if (this.cat && !bl) {
            return;
        }
        if (!this.muteNotify) {
            this.NotifyAll(new NotifyMsg(this, 12290));
        }
    }

    public void sortCategories(int n) {
        if (!this.isCat() || this.cats.length < 2) {
            return;
        }
    }

    public void dropCat() {
        this.cat = false;
        if (!this.muteNotify) {
            this.NotifyAll(new NotifyMsg(this, 12290));
        }
    }

    public void setCategorical(boolean bl) {
        this.cat = true;
    }

    public boolean add(Object object) {
        return false;
    }

    public boolean remove(int n) {
        int n2 = this.size();
        this.temp = new int[--n2];
        try {
            int n3 = 0;
            for (int i = 0; i < this.cont.length && n3 < this.temp.length; ++n3, ++i) {
                if (n3 == n) {
                    ++i;
                }
                this.temp[n3] = this.cont[i];
            }
            this.cont = this.temp;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean insert(Object object, int n) {
        int n2 = this.size();
        this.temp = new int[++n2];
        try {
            int n3;
            int n4 = 0;
            for (n3 = 0; n3 < this.cont.length && n4 < this.temp.length; ++n4, ++n3) {
                if (n4 == n) {
                    --n3;
                    continue;
                }
                this.temp[n4] = this.cont[n3];
            }
            this.cont = this.temp;
            if (object == null) {
                this.cont[n] = this.getCatIndex("NA");
            } else {
                n4 = this.getCatIndex(object.toString());
                if (n4 == -1) {
                    this.tempcats = new String[this.cats.length + 1];
                    for (n3 = 0; n3 < this.cats.length; ++n3) {
                        this.tempcats[n3] = this.cats[n3];
                    }
                    this.tempcats[this.tempcats.length - 1] = object.toString();
                    this.cats = this.tempcats;
                    n4 = this.getCatIndex(object.toString());
                }
                this.cont[n] = this.getCatIndex(object.toString());
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean replace(int n, Object object) {
        int n2 = this.getCatIndex(object.toString());
        if (n2 == -1) {
            this.tempcats = new String[this.cats.length + 1];
            for (int i = 0; i < this.cats.length; ++i) {
                this.tempcats[i] = this.cats[i];
            }
            try {
                this.tempcats[this.tempcats.length - 1] = object.toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println(this.tempcats[this.tempcats.length - 1]);
            this.cats = this.tempcats;
            System.out.println(object.toString());
            n2 = this.getCatIndex(object.toString());
        }
        this.cont[n] = n2;
        return false;
    }

    public Object at(int n) {
        return n < 0 || n >= this.cont.length || this.cont[n] < 0 || this.cont[n] > this.cats.length ? null : this.cats[this.cont[n]];
    }

    public int atI(int n) {
        return n < 0 || n >= this.cont.length || this.cont[n] < 0 || this.cont[n] > this.cats.length ? -1 : this.cont[n];
    }

    public int getCatIndex(Object object) {
        if (this.cats == null || "NA".equals(object)) {
            return -1;
        }
        for (int i = 0; i < this.cats.length; ++i) {
            if (!this.cats[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    public int getCatIndex(int n) {
        return n < 0 || n >= this.cont.length || this.cont[n] < 0 || this.cont[n] >= this.cats.length ? -1 : this.cont[n];
    }

    public Object getCatAt(int n) {
        return n < 0 || n >= this.cats.length ? "NA" : this.cats[n];
    }

    public int getSizeCatAt(int n) {
        if (this.cats == null) {
            return -1;
        }
        if (n == -1) {
            return this.missingCount;
        }
        return n < 0 || n >= this.cats.length ? -1 : this.ccnts[n];
    }

    public int getSizeCat(Object object) {
        if (object == null || object.equals("NA")) {
            return this.missingCount;
        }
        int n = this.getCatIndex(object);
        return n < 0 || n >= this.cats.length ? -1 : this.ccnts[n];
    }

    public int getNumCats() {
        if (this.cats == null) {
            return 0;
        }
        return this.cats.length;
    }

    public Object[] getCategories() {
        return this.cats;
    }

    public int[] getRanked(SMarker sMarker, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        Stopwatch stopwatch = new Stopwatch();
        if (sMarker == null && this.cacheRanks && this.ranks != null) {
            return this.ranks;
        }
        int[] nArray = null;
        if (!this.cacheRanks || this.ranks == null) {
            n5 = this.size();
            if (n5 == 0) {
                return null;
            }
            nArray = new int[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                nArray[n4] = n4;
            }
            stopwatch.profile("getRanked: prepare");
            for (n4 = 0; n4 < n5 - 1; ++n4) {
                n3 = this.cont[nArray[n4]];
                for (int i = n5 - 1; i > n4; --i) {
                    n2 = this.cont[nArray[i]];
                    if (n2 >= n3) continue;
                    int n6 = nArray[n4];
                    nArray[n4] = nArray[i];
                    nArray[i] = n6;
                    n3 = n2;
                }
            }
            stopwatch.profile("getRanked: sort");
            if (this.cacheRanks) {
                this.ranks = nArray;
            }
        } else {
            nArray = this.ranks;
        }
        if (sMarker != null && nArray != null) {
            n5 = nArray.length;
            n4 = 0;
            for (n3 = 0; n3 < n5; ++n3) {
                if (sMarker.get(n3) != n) continue;
                ++n4;
            }
            if (n4 == 0) {
                return null;
            }
            int[] nArray2 = new int[n4];
            n2 = 0;
            for (n3 = 0; n3 < n5; ++n3) {
                if (sMarker.get(nArray[n3]) != n) continue;
                nArray2[n2++] = nArray[n3];
            }
            nArray = null;
            nArray = nArray2;
        }
        return nArray;
    }

    public String toString() {
        return "SVarFact(\"" + this.name + "\"," + (this.cat ? "cat," : "cont,") + (this.isnum ? "num," : "txt,") + "n=" + this.size() + ",miss=" + this.missingCount + ")";
    }
}

