% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QR_functions.R
\name{fr-add_indicator}
\alias{fr-add_indicator}
\title{Ajout d'un indicateur dans les objets QR_matrix}
\arguments{
\item{x}{objet de type \code{\link{QR_matrix}} ou \code{\link{mQR_matrix}}.}

\item{indicator}{un \code{vector} ou un \code{data.frame} (voir détails).}

\item{variable_name}{chaîne de caractères contenant les noms des nouvelles
variables.}

\item{...}{autres paramètres de la fonction \code{\link[base]{merge}}.}
}
\value{
Cette fonction renvoie le même objet, enrichi de l'indicateur
choisi. Ainsi, si l'entrée \code{x} est une matrice QR, un objet de la classe
\code{QR_matrix} est renvoyé. Si le code d'entrée \code{x} est une matrice
mQR, un objet de la classe \code{mQR_matrix} est renvoyé.
}
\description{
Permet d'ajouter un indicateur dans les objets \code{\link{QR_matrix}}.
}
\details{
La fonction \code{add_indicator()} permet d'ajouter un indicateur
dans la matrice des valeurs du bilan qualité. L'indicateur n'est donc pas
ajouté dans la matrice des modalités et ne peut être utilisé dans le calcul
du score (sauf pour le pondérer). Pour l'utiliser dans le calcul du score, il
faudra d'abord le recoder avec la fonction
\code{\link{recode_indicator_num}}.

L'indicateur à ajouter peut être sous deux formats : \code{vector} ou
\code{data.frame}. Dans les deux cas, il faut que les valeurs à ajouter
puissent être associées aux bonnes séries dans la matrice du bilan qualité :
\itemize{
\item dans le cas d'un \code{vector}, les éléments devront être nommés et les
noms doivent correspondre à ceux présents dans le bilan qualité (variable
"series") ;
\item dans le cas d'un \code{data.frame}, il devra contenir une colonne "series"
avec les noms des séries correspondantes.
}
}
\keyword{internal}
