% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QR_functions.R
\name{extract_score}
\alias{extract_score}
\title{Score extraction}
\usage{
extract_score(
  x,
  format_output = c("data.frame", "vector"),
  weighted_score = FALSE
)
}
\arguments{
\item{x}{a \code{\link{QR_matrix}} or \code{\link{mQR_matrix}}.}

\item{format_output}{string of characters indicating the output format: either a \code{data.frame} or a \code{vector}.}

\item{weighted_score}{logical indicating whether to extract the weighted score (if previously calculated) or the unweighted one.
By default, the unweighted score is extracted.}
}
\value{
\code{extract_score()} returns a data.frame with two column: the series name and their score.
}
\description{
To extract score variables from \code{\link{QR_matrix}} or \code{\link{mQR_matrix}} objects.
}
\details{
For \code{\link{QR_matrix}} objects, the output is a vector or the object \code{NULL} if no score was previously calculated.
For \code{\link{mQR_matrix}} objects, it is a list of scores (\code{NULL} elements or vectors).
}
\examples{
# Path of matrix demetra_m
demetra_path <- file.path(
    system.file("extdata", package = "JDCruncheR"),
    "WS/ws_ipi/Output/SAProcessing-1",
    "demetra_m.csv"
)

# Extract the quality report from the demetra_m file
QR <- extract_QR(demetra_path)

# Compute the score
QR1 <- compute_score(QR, n_contrib_score = 2)
mQR <- mQR_matrix(QR, compute_score(QR))

# Extract score
extract_score(QR1)
extract_score(mQR)

}
\seealso{
\link[=fr-extract_score]{Traduction française}
}
