% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concordia.R
\name{concordia.plot}
\alias{concordia.plot}
\title{Plot concordia diagrams}
\usage{
concordia.plot(X, limits = NA, alpha = 0.05, wetherill = TRUE,
  show.labels = FALSE, ellipse.col = rgb(0, 1, 0, 0.5),
  concordia.col = rgb(1, 0, 0, 0.5))
}
\arguments{
\item{X}{a U-Pb dataset, i.e. a matrix with the following columns:
ID, Pb207Pb206, sePb207Pb206, Pb206U238, sePb206U238,
Pb207U235, sePb207U235}

\item{limits}{age limits of the concordia line}

\item{alpha}{confidence cutoff for the error ellipses}

\item{wetherill}{boolean flag (FALSE for Tera-Wasserburg)}

\item{show.labels}{boolean flag (TRUE to show grain numbers)}

\item{ellipse.col}{background colour of the error ellipses}

\item{concordia.col}{colour of the concordia line}
}
\description{
Wetherill and Tera-Wasserburg concordia diagrams
}
\examples{
data(UPb)
concordia.plot(UPb)
}

