% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Irescale.R
\name{calculateEuclideanDistance}
\alias{calculateEuclideanDistance}
\title{Given a 2D data structure, it calculates the euclidean distance among all the points.}
\usage{
calculateEuclideanDistance(data)
}
\arguments{
\item{data}{2D data structure for latitute and longitute respectively.}
}
\value{
Matrix, of size \eqn{nrow(data) \times nrow(data)}, with the distance between all the pair of points.
}
\description{
\code{calculateEuclideanDistance} Computes the euclidean distance betwen all pairs of nodes provided in the input vector.
}
\details{
Computes the euclidean distance, \eqn{\sqrt{(x_1-x_2)^2 + (y_1-y_2)^2}}, matrix between each pair of points.
}
\examples{
fileInput <- system.file("testdata", "chen.csv", package="Irescale")
data<-loadFile(fileInput)
distM<-calculateEuclideanDistance(data$data)
}
