% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{FindGenes}
\alias{FindGenes}
\title{Investigates whether genes are differential expressed in multiple clusters}
\usage{
FindGenes(dataLimma, names = NULL)
}
\arguments{
\item{dataLimma}{Preferably an output of the \code{DiffGenes} function. If
not, an ID element of the top genes must be present for each cluster of each
method specified in the data structure.}

\item{names}{Optional. Names of the methods. Default is NULL.}
}
\value{
The returned value is a list with an element per cluster and per
cluster one for every gene.  Per gene, a vector is given which contain the
methods for which the gene was found. If the cluster is changed compared to
the reference method of DataLimma, this is indicated with an underscore.
}
\description{
Due to the shifting of objects over the clusters for the different
methods, it is possible that the same gene is found significant for a
different cluster in another method. These can be tracked with the
\code{FindGenes} function. Per method and per cluster, it will take note of
the genes found significant and investigate if these were also find for
another cluster in another method.
}
\examples{

data(fingerprintMat)
data(targetMat)
data(geneMat)

MCF7_F = Cluster(fingerprintMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)
MCF7_T = Cluster(targetMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)

MCF7_DiffGenes_FandT10=DiffGenes(list(MCF7_F,MCF7_T),Selection=NULL,geneExpr=geneMat,
nrclusters=7,method="limma",sign=0.05,top=10,fusionsLog = TRUE, weightclust = TRUE, 
names = NULL)

MCF7_SharedGenes=FindGenes(dataLimma=MCF7_DiffGenes_FandT10,names=c("FP","TP"))
}
\author{
Marijke Van Moerbeke
}
