% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_aggregation_AMPI.R
\name{linear_aggregation_AMPI}
\alias{linear_aggregation_AMPI}
\title{Adjusted Mazziotta-Pareto index}
\usage{
linear_aggregation_AMPI(data, pol = "pos")
}
\arguments{
\item{data}{dataframe with rows = observations and columns = quantitative variables}

\item{pol}{pol if not selected is "positive"", otherwise write "neg" (see details)}
}
\value{
It returns a dataframe with rows = observations and column = composite indicator
}
\description{
The Adjusted Mazziotta-Pareto Index (AMPI) is a composite index for
summarizing a set of indicators that are assumed to be non-substitutable,
i.e., all components must be balanced. It is based on a non-linear function
which, starting from the arithmetic mean, introduces a penalty for the units
with unbalanced values of the indicators
}
\details{
The ‘polarity’ of an indicator is the sign of the relation between the
indicator and the phenomenon to be measured ( + if the indicator represents
a dimension considered positive and - otherwise)
}
\examples{

data("Education")
Indicator=linear_aggregation_AMPI(Education)
print(Indicator)

#----With negative polarity
Indicator_neg=linear_aggregation_AMPI(Education,"neg")
print(Indicator_neg)

}
\references{
Matteo Mazziotta & Adriano Pareto, 2018. "Measuring Well-Being
Over Time: The Adjusted Mazziotta–Pareto Index Versus Other Non-compensatory
Indices," Social Indicators Research: An International and Interdisciplinary
Journal for Quality-of-Life Measurement, Springer, vol. 136(3), pages
967-976, April
}
\keyword{AMPI}
\keyword{Adjusted}
\keyword{Index}
\keyword{Mazziotta-Pareto}
