test_that("shares are calculated correctly", {

  result <- shares(CES_sigma_2, "prices", "quantities", "time", "prodID")

  expected <- data.frame(c(0.0769230803846, 0.0787045798308, 0.1037891205661, 0.1143677119758,
                           0.0993788819867, 0.1298579048651, 0.128185228718, 0.1114551097378,
                           0.1351568753154, 0.1225490205106, 0.1513326046489, 0.1590214085231),
                         c(0.1538461507692, 0.2754660121002, 0.1581548572263, 0.1559559642852,
                           0.1286601567828, 0.1580878906886, 0.1466525996162, 0.2414860688436,
                           0.1407884163285, 0.1176470560458, 0.1359628885269, 0.1345565757187),
                         c(0.1538461507692, 0.1449821144252, 0.1845140082792, 0.2018253661583,
                           0.360248447952, 0.2272513419755, 0.2307334174781, 0.2012383901147,
                           0.2413515678965, 0.3676470593096, 0.2486178503384, 0.2691131476138),
                         c(0.6153846180769, 0.5008472936437, 0.5535420139284, 0.5278509575807,
                           0.4117125132784, 0.4848028624708, 0.4944287541877, 0.445820431304,
                           0.4827031404596, 0.392156864134, 0.4640866564858, 0.4373088681445))
  colnames(expected) <- 1:4

  expect_equal(round(result, 7), round(expected, 7))

})

test_that("predictedShares calculates correctly", {

  result <- predictedShares(CES_sigma_2[CES_sigma_2$time <= 4,], "prices",
                            "quantities", "time", "prodID")

  expected <- list(matrix(
    c(0.07692308038, 0.07202712412, 0.13704636463, 0.16261307027,
    0.06958250799, 0.07870457983, 0.12740532207, 0.15222398342,
    0.05594405846, 0.05393511397, 0.10378912057, 0.12553174851,
    0.04983388928, 0.04835511341, 0.09383761981, 0.11436771198), nrow = 4, ncol = 4
  ),
  matrix(
    c(0.15384615077, 0.4411661075, 0.15911052546, 0.15118983167,
    0.07952286111, 0.2754660121, 0.08452416938, 0.08087460407,
    0.14685314392, 0.43358772492, 0.15815485723, 0.15318633436,
    0.14617939906, 0.43439007485, 0.15978639384, 0.15595596429), nrow = 4, ncol = 4
  ),
  matrix(
    c(0.15384615077, 0.12220668033, 0.2165671137, 0.25320373271,
    0.1510934361, 0.14498211443, 0.21858890329, 0.25734355061,
    0.12587412336, 0.10294920458, 0.18451400828, 0.21989773422,
    0.11295680836, 0.09298201227, 0.16805817168, 0.20182536616), nrow = 4, ncol = 4
  ),
  matrix(
    c(0.61538461808, 0.36460008805, 0.48727599621, 0.43299336535,
    0.6998011948, 0.50084729364, 0.56948160525, 0.5095578619,
    0.67132867427, 0.40952795653, 0.55354201393, 0.5013841829,
    0.6910299033, 0.42427279946, 0.57831781467, 0.52785095758), nrow = 4, ncol = 4
  ))

  result <- lapply(result, round, 7)
  expected <- lapply(expected, round, 7)

  expect_equal(result, expected)

})

