/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.Timer;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.BenchmarkMatrixKernel;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix3D;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Random;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class BenchmarkDenseDoubleMatrix3D {
    private static Timer t = new Timer();
    private static final String outputFile = "BenchmarkDenseDoubleMatrix3D.txt";
    private static double[][][] a_3d;
    private static double[][][] b_3d;
    private static double[] a_1d;
    private static double[] b_1d;
    private static double[] noViewTimes;
    private static double[] viewTimes;

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{"cern.colt.matrix.tdouble.impl.BenchmarkDenseDoubleMatrix3D"});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        int n;
        int n2;
        int n3;
        BenchmarkMatrixKernel.readSettings3D();
        Random random = new Random(0L);
        ConcurrencyUtils.setThreadsBeginN_3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[1] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        a_1d = new double[BenchmarkMatrixKernel.MATRIX_SIZE_3D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[1] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]];
        a_3d = new double[BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]][BenchmarkMatrixKernel.MATRIX_SIZE_3D[1]][BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]];
        int n4 = 0;
        for (n3 = 0; n3 < BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]; ++n3) {
            for (n2 = 0; n2 < BenchmarkMatrixKernel.MATRIX_SIZE_3D[1]; ++n2) {
                for (n = 0; n < BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]; ++n) {
                    BenchmarkDenseDoubleMatrix3D.a_3d[n3][n2][n] = random.nextDouble();
                    BenchmarkDenseDoubleMatrix3D.a_1d[n4++] = a_3d[n3][n2][n];
                }
            }
        }
        b_1d = new double[BenchmarkMatrixKernel.MATRIX_SIZE_3D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[1] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]];
        b_3d = new double[BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]][BenchmarkMatrixKernel.MATRIX_SIZE_3D[1]][BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]];
        n4 = 0;
        for (n3 = 0; n3 < BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]; ++n3) {
            for (n2 = 0; n2 < BenchmarkMatrixKernel.MATRIX_SIZE_3D[1]; ++n2) {
                for (n = 0; n < BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]; ++n) {
                    BenchmarkDenseDoubleMatrix3D.b_3d[n3][n2][n] = random.nextDouble();
                    BenchmarkDenseDoubleMatrix3D.b_1d[n4++] = b_3d[n3][n2][n];
                }
            }
        }
        BenchmarkMatrixKernel.writePropertiesToFile(outputFile, BenchmarkMatrixKernel.MATRIX_SIZE_3D);
        BenchmarkMatrixKernel.displayProperties(BenchmarkMatrixKernel.MATRIX_SIZE_3D);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        a_1d = null;
        a_3d = null;
        b_1d = null;
        b_3d = null;
        ConcurrencyUtils.resetThreadsBeginN();
        System.gc();
    }

    @Before
    public void setUpBefore() {
        noViewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
        viewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
    }

    @Test
    public void testAggregateDoubleDoubleFunctionDoubleFunction() {
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double d = ((DoubleMatrix3D)denseDoubleMatrix3D).aggregate(DoubleFunctions.plus, DoubleFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = ((DoubleMatrix3D)denseDoubleMatrix3D).aggregate(DoubleFunctions.plus, DoubleFunctions.square);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double d = doubleMatrix3D.aggregate(DoubleFunctions.plus, DoubleFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = doubleMatrix3D.aggregate(DoubleFunctions.plus, DoubleFunctions.square);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(DoubleDoubleFunction, DoubleFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateDoubleDoubleFunctionDoubleFunctionDoubleProcedure() {
        DoubleProcedure doubleProcedure = new DoubleProcedure(){

            public boolean apply(double d) {
                return Math.abs(d) > 0.2;
            }
        };
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double d = ((DoubleMatrix3D)denseDoubleMatrix3D).aggregate(DoubleFunctions.plus, DoubleFunctions.square, doubleProcedure);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = ((DoubleMatrix3D)denseDoubleMatrix3D).aggregate(DoubleFunctions.plus, DoubleFunctions.square, doubleProcedure);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double d = doubleMatrix3D.aggregate(DoubleFunctions.plus, DoubleFunctions.square, doubleProcedure);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = doubleMatrix3D.aggregate(DoubleFunctions.plus, DoubleFunctions.square, doubleProcedure);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(DoubleDoubleFunction, DoubleFunction, DoubleProcedure)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateDoubleDoubleFunctionDoubleFunctionIntArrayListIntArrayListIntArrayList() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        for (n = 0; n < BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]; ++n) {
            for (int i = 0; i < BenchmarkMatrixKernel.MATRIX_SIZE_3D[1]; ++i) {
                for (int j = 0; j < BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]; ++j) {
                    intArrayList.add(n);
                    intArrayList2.add(i);
                    intArrayList3.add(j);
                }
            }
        }
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double d = ((DoubleMatrix3D)denseDoubleMatrix3D).aggregate(DoubleFunctions.plus, DoubleFunctions.square, intArrayList, intArrayList2, intArrayList3);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = ((DoubleMatrix3D)denseDoubleMatrix3D).aggregate(DoubleFunctions.plus, DoubleFunctions.square, intArrayList, intArrayList2, intArrayList3);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double d = doubleMatrix3D.aggregate(DoubleFunctions.plus, DoubleFunctions.square, intArrayList, intArrayList2, intArrayList3);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = doubleMatrix3D.aggregate(DoubleFunctions.plus, DoubleFunctions.square, intArrayList, intArrayList2, intArrayList3);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(DoubleDoubleFunction, DoubleFunction, IntArrayList, IntArrayList, IntArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateDoubleMatrix3DDoubleDoubleFunctionDoubleDoubleFunction() {
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        DenseDoubleMatrix3D denseDoubleMatrix3D2 = new DenseDoubleMatrix3D(b_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double d = ((DoubleMatrix3D)denseDoubleMatrix3D).aggregate(denseDoubleMatrix3D2, DoubleFunctions.plus, DoubleFunctions.mult);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = ((DoubleMatrix3D)denseDoubleMatrix3D).aggregate(denseDoubleMatrix3D2, DoubleFunctions.plus, DoubleFunctions.mult);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        DoubleMatrix3D doubleMatrix3D2 = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(b_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double d = doubleMatrix3D.aggregate(doubleMatrix3D2, DoubleFunctions.plus, DoubleFunctions.mult);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = doubleMatrix3D.aggregate(doubleMatrix3D2, DoubleFunctions.plus, DoubleFunctions.mult);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(DoubleMatrix3D, DoubleDoubleFunction, DoubleDoubleFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDouble() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        double d = Math.random();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DoubleMatrix3D)denseDoubleMatrix3D).assign(d);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DoubleMatrix3D)denseDoubleMatrix3D).assign(0.0);
                t.reset().start();
                ((DoubleMatrix3D)denseDoubleMatrix3D).assign(d);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            doubleMatrix3D.assign(d);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix3D.assign(0.0);
                t.reset().start();
                doubleMatrix3D.assign(d);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(double)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleArray() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DoubleMatrix3D)denseDoubleMatrix3D).assign(a_1d);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DoubleMatrix3D)denseDoubleMatrix3D).assign(0.0);
                t.reset().start();
                ((DoubleMatrix3D)denseDoubleMatrix3D).assign(a_1d);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            doubleMatrix3D.assign(a_1d);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix3D.assign(0.0);
                t.reset().start();
                doubleMatrix3D.assign(a_1d);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(double[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleArrayArrayArray() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DoubleMatrix3D)denseDoubleMatrix3D).assign(a_3d);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DoubleMatrix3D)denseDoubleMatrix3D).assign(0.0);
                t.reset().start();
                ((DoubleMatrix3D)denseDoubleMatrix3D).assign(a_3d);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            doubleMatrix3D.assign(a_3d);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix3D.assign(0.0);
                t.reset().start();
                doubleMatrix3D.assign(a_3d);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(double[][][])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleFunction() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DoubleMatrix3D)denseDoubleMatrix3D).assign(DoubleFunctions.square);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DoubleMatrix3D)denseDoubleMatrix3D).assign(a_3d);
                t.reset().start();
                ((DoubleMatrix3D)denseDoubleMatrix3D).assign(DoubleFunctions.square);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            doubleMatrix3D.assign(DoubleFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix3D.assign(a_3d);
                t.reset().start();
                doubleMatrix3D.assign(DoubleFunctions.square);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DoubleFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleMatrix3D() {
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        DenseDoubleMatrix3D denseDoubleMatrix3D2 = new DenseDoubleMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DoubleMatrix3D)denseDoubleMatrix3D).assign(denseDoubleMatrix3D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DoubleMatrix3D)denseDoubleMatrix3D).assign(0.0);
                t.reset().start();
                ((DoubleMatrix3D)denseDoubleMatrix3D).assign(denseDoubleMatrix3D2);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        DoubleMatrix3D doubleMatrix3D2 = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(b_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            doubleMatrix3D.assign(doubleMatrix3D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix3D.assign(0.0);
                t.reset().start();
                doubleMatrix3D.assign(doubleMatrix3D2);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DoubleMatrix3D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleMatrix3DDoubleDoubleFunction() {
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        DenseDoubleMatrix3D denseDoubleMatrix3D2 = new DenseDoubleMatrix3D(b_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DoubleMatrix3D)denseDoubleMatrix3D).assign(denseDoubleMatrix3D2, DoubleFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DoubleMatrix3D)denseDoubleMatrix3D).assign(a_3d);
                t.reset().start();
                ((DoubleMatrix3D)denseDoubleMatrix3D).assign(denseDoubleMatrix3D2, DoubleFunctions.div);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        DoubleMatrix3D doubleMatrix3D2 = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(b_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            doubleMatrix3D.assign(doubleMatrix3D2, DoubleFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix3D.assign(a_3d);
                t.reset().start();
                doubleMatrix3D.assign(doubleMatrix3D2, DoubleFunctions.div);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DoubleMatrix3D, DoubleDoubleFuction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleMatrix3DDoubleDoubleFunctionIntArrayListIntArrayListIntArrayList() {
        int n;
        int n2;
        int n3;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        DenseDoubleMatrix3D denseDoubleMatrix3D2 = new DenseDoubleMatrix3D(b_3d);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        for (n3 = 0; n3 < BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]; ++n3) {
            for (n2 = 0; n2 < BenchmarkMatrixKernel.MATRIX_SIZE_3D[1]; ++n2) {
                for (n = 0; n < BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]; ++n) {
                    intArrayList.add(n3);
                    intArrayList2.add(n2);
                    intArrayList3.add(n);
                }
            }
        }
        n3 = 0;
        while (n3 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n3]);
            ((DoubleMatrix3D)denseDoubleMatrix3D).assign(denseDoubleMatrix3D2, DoubleFunctions.div, intArrayList, intArrayList2, intArrayList3);
            for (n2 = 0; n2 < BenchmarkMatrixKernel.NITERS; ++n2) {
                ((DoubleMatrix3D)denseDoubleMatrix3D).assign(a_3d);
                t.reset().start();
                ((DoubleMatrix3D)denseDoubleMatrix3D).assign(denseDoubleMatrix3D2, DoubleFunctions.div, intArrayList, intArrayList2, intArrayList3);
                t.stop();
                int n4 = n3;
                noViewTimes[n4] = noViewTimes[n4] + t.millis();
            }
            int n5 = n3++;
            noViewTimes[n5] = noViewTimes[n5] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        DoubleMatrix3D doubleMatrix3D2 = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(b_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            doubleMatrix3D.assign(doubleMatrix3D2, DoubleFunctions.div, intArrayList, intArrayList2, intArrayList3);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix3D.assign(a_3d);
                t.reset().start();
                doubleMatrix3D.assign(doubleMatrix3D2, DoubleFunctions.div, intArrayList, intArrayList2, intArrayList3);
                t.stop();
                int n6 = n;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DoubleMatrix3D, DoubleDoubleFuction, IntArrayList, IntArrayList, IntArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleProcedureDouble() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        DoubleProcedure doubleProcedure = new DoubleProcedure(){

            public boolean apply(double d) {
                return Math.abs(d) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DoubleMatrix3D)denseDoubleMatrix3D).assign(doubleProcedure, -1.0);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DoubleMatrix3D)denseDoubleMatrix3D).assign(a_3d);
                t.reset().start();
                ((DoubleMatrix3D)denseDoubleMatrix3D).assign(doubleProcedure, -1.0);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            doubleMatrix3D.assign(doubleProcedure, -1.0);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix3D.assign(a_3d);
                t.reset().start();
                doubleMatrix3D.assign(doubleProcedure, -1.0);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DoubleProcedure, double)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleProcedureDoubleFunction() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        DoubleProcedure doubleProcedure = new DoubleProcedure(){

            public boolean apply(double d) {
                return Math.abs(d) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DoubleMatrix3D)denseDoubleMatrix3D).assign(doubleProcedure, DoubleFunctions.square);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DoubleMatrix3D)denseDoubleMatrix3D).assign(a_3d);
                t.reset().start();
                ((DoubleMatrix3D)denseDoubleMatrix3D).assign(doubleProcedure, DoubleFunctions.square);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            doubleMatrix3D.assign(doubleProcedure, DoubleFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                doubleMatrix3D.assign(a_3d);
                t.reset().start();
                doubleMatrix3D.assign(doubleProcedure, DoubleFunctions.square);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DoubleProcedure, DoubleFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testCardinality() {
        int n;
        int n2;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n3 = 0;
        while (n3 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n3]);
            n2 = ((DoubleMatrix3D)denseDoubleMatrix3D).cardinality();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                n2 = ((DoubleMatrix3D)denseDoubleMatrix3D).cardinality();
                t.stop();
                int n4 = n3;
                noViewTimes[n4] = noViewTimes[n4] + t.millis();
            }
            int n5 = n3++;
            noViewTimes[n5] = noViewTimes[n5] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        DoubleMatrix3D doubleMatrix3D = denseDoubleMatrix3D.viewDice(2, 1, 0);
        n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            n = doubleMatrix3D.cardinality();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                n = doubleMatrix3D.cardinality();
                t.stop();
                int n6 = n2;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n2++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "cardinality()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDct3() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix3D.dct3(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix3D.assign(a_3d);
                t.reset().start();
                denseDoubleMatrix3D.dct3(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix3D)doubleMatrix3D).dct3(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix3D)doubleMatrix3D).assign(a_3d);
                t.reset().start();
                ((DenseDoubleMatrix3D)doubleMatrix3D).dct3(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dct3(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDct2Slices() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix3D.dct2Slices(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix3D.assign(a_3d);
                t.reset().start();
                denseDoubleMatrix3D.dct2Slices(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix3D)doubleMatrix3D).dct2Slices(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix3D)doubleMatrix3D).assign(a_3d);
                t.reset().start();
                ((DenseDoubleMatrix3D)doubleMatrix3D).dct2Slices(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dct2Slices(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDst3() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix3D.dst3(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix3D.assign(a_3d);
                t.reset().start();
                denseDoubleMatrix3D.dst3(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix3D)doubleMatrix3D).dst3(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix3D)doubleMatrix3D).assign(a_3d);
                t.reset().start();
                ((DenseDoubleMatrix3D)doubleMatrix3D).dst3(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dst3(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDst2Slices() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix3D.dst2Slices(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix3D.assign(a_3d);
                t.reset().start();
                denseDoubleMatrix3D.dst2Slices(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix3D)doubleMatrix3D).dst2Slices(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix3D)doubleMatrix3D).assign(a_3d);
                t.reset().start();
                ((DenseDoubleMatrix3D)doubleMatrix3D).dst2Slices(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dst2Slices(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDht3() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix3D.dht3();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix3D.assign(a_3d);
                t.reset().start();
                denseDoubleMatrix3D.dht3();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix3D)doubleMatrix3D).dht3();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix3D)doubleMatrix3D).assign(a_3d);
                t.reset().start();
                ((DenseDoubleMatrix3D)doubleMatrix3D).dht3();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dht3()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDht2Slices() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix3D.dht2Slices();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix3D.assign(a_3d);
                t.reset().start();
                denseDoubleMatrix3D.dht2Slices();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix3D)doubleMatrix3D).dht2Slices();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix3D)doubleMatrix3D).assign(a_3d);
                t.reset().start();
                ((DenseDoubleMatrix3D)doubleMatrix3D).dht2Slices();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dht2Slices()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFft3() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix3D.fft3();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix3D.assign(a_3d);
                t.reset().start();
                denseDoubleMatrix3D.fft3();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix3D)doubleMatrix3D).fft3();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix3D)doubleMatrix3D).assign(a_3d);
                t.reset().start();
                ((DenseDoubleMatrix3D)doubleMatrix3D).fft3();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "fft3()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetFft3() {
        int n;
        DenseDComplexMatrix3D denseDComplexMatrix3D;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDComplexMatrix3D = denseDoubleMatrix3D.getFft3();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix3D.assign(a_3d);
                t.reset().start();
                denseDComplexMatrix3D = denseDoubleMatrix3D.getFft3();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            denseDComplexMatrix3D = ((DenseDoubleMatrix3D)doubleMatrix3D).getFft3();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix3D)doubleMatrix3D).assign(a_3d);
                t.reset().start();
                denseDComplexMatrix3D = ((DenseDoubleMatrix3D)doubleMatrix3D).getFft3();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getFft3()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetFft2Slices() {
        int n;
        DenseDComplexMatrix3D denseDComplexMatrix3D;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDComplexMatrix3D = denseDoubleMatrix3D.getFft2Slices();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix3D.assign(a_3d);
                t.reset().start();
                denseDComplexMatrix3D = denseDoubleMatrix3D.getFft2Slices();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            denseDComplexMatrix3D = ((DenseDoubleMatrix3D)doubleMatrix3D).getFft2Slices();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix3D)doubleMatrix3D).assign(a_3d);
                t.reset().start();
                denseDComplexMatrix3D = ((DenseDoubleMatrix3D)doubleMatrix3D).getFft2Slices();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getFft2Slices()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetIfft3() {
        int n;
        DenseDComplexMatrix3D denseDComplexMatrix3D;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDComplexMatrix3D = denseDoubleMatrix3D.getIfft3(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix3D.assign(a_3d);
                t.reset().start();
                denseDComplexMatrix3D = denseDoubleMatrix3D.getIfft3(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            denseDComplexMatrix3D = ((DenseDoubleMatrix3D)doubleMatrix3D).getIfft3(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix3D)doubleMatrix3D).assign(a_3d);
                t.reset().start();
                denseDComplexMatrix3D = ((DenseDoubleMatrix3D)doubleMatrix3D).getIfft3(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getIfft3(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetIfft2Slices() {
        int n;
        DenseDComplexMatrix3D denseDComplexMatrix3D;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDComplexMatrix3D = denseDoubleMatrix3D.getIfft2Slices(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix3D.assign(a_3d);
                t.reset().start();
                denseDComplexMatrix3D = denseDoubleMatrix3D.getIfft2Slices(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            denseDComplexMatrix3D = ((DenseDoubleMatrix3D)doubleMatrix3D).getIfft2Slices(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix3D)doubleMatrix3D).assign(a_3d);
                t.reset().start();
                denseDComplexMatrix3D = ((DenseDoubleMatrix3D)doubleMatrix3D).getIfft2Slices(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getIfft2Slices(true)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetNegativeValuesIntArrayListIntArrayListIntArrayListDoubleArrayList() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        denseDoubleMatrix3D.assign(DoubleFunctions.mult(-1.0));
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix3D.getNegativeValues(intArrayList, intArrayList2, intArrayList3, doubleArrayList);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                intArrayList.clear();
                intArrayList2.clear();
                intArrayList3.clear();
                doubleArrayList.clear();
                t.reset().start();
                denseDoubleMatrix3D.getNegativeValues(intArrayList, intArrayList2, intArrayList3, doubleArrayList);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        doubleArrayList.clear();
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(a_3d).viewDice(2, 1, 0);
        ((DenseDoubleMatrix3D)doubleMatrix3D).assign(DoubleFunctions.mult(-1.0));
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix3D)doubleMatrix3D).getNegativeValues(intArrayList, intArrayList2, intArrayList3, doubleArrayList);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                intArrayList.clear();
                intArrayList2.clear();
                intArrayList3.clear();
                doubleArrayList.clear();
                t.reset().start();
                ((DenseDoubleMatrix3D)doubleMatrix3D).getNegativeValues(intArrayList, intArrayList2, intArrayList3, doubleArrayList);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getNegativeValues(IntArrayList, IntArrayList, IntArrayList, DoubleArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetNonZerosIntArrayListIntArrayListIntArrayListDoubleArrayList() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix3D.getNonZeros(intArrayList, intArrayList2, intArrayList3, doubleArrayList);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                intArrayList.clear();
                intArrayList2.clear();
                intArrayList3.clear();
                doubleArrayList.clear();
                t.reset().start();
                denseDoubleMatrix3D.getNonZeros(intArrayList, intArrayList2, intArrayList3, doubleArrayList);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        doubleArrayList.clear();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix3D)doubleMatrix3D).getNonZeros(intArrayList, intArrayList2, intArrayList3, doubleArrayList);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                intArrayList.clear();
                intArrayList2.clear();
                intArrayList3.clear();
                doubleArrayList.clear();
                t.reset().start();
                ((DenseDoubleMatrix3D)doubleMatrix3D).getNonZeros(intArrayList, intArrayList2, intArrayList3, doubleArrayList);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getNonZeros(IntArrayList, IntArrayList, IntArrayList, DoubleArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetPositiveValuesIntArrayListIntArrayListIntArrayListDoubleArrayList() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix3D.getPositiveValues(intArrayList, intArrayList2, intArrayList3, doubleArrayList);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                intArrayList.clear();
                intArrayList2.clear();
                intArrayList3.clear();
                doubleArrayList.clear();
                t.reset().start();
                denseDoubleMatrix3D.getPositiveValues(intArrayList, intArrayList2, intArrayList3, doubleArrayList);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        doubleArrayList.clear();
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(a_3d).viewDice(2, 1, 0);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix3D)doubleMatrix3D).getPositiveValues(intArrayList, intArrayList2, intArrayList3, doubleArrayList);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                intArrayList.clear();
                intArrayList2.clear();
                intArrayList3.clear();
                doubleArrayList.clear();
                t.reset().start();
                ((DenseDoubleMatrix3D)doubleMatrix3D).getPositiveValues(intArrayList, intArrayList2, intArrayList3, doubleArrayList);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getPositiveValues(IntArrayList, IntArrayList, IntArrayList, DoubleArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdct3() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix3D.idct3(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix3D.assign(a_3d);
                t.reset().start();
                denseDoubleMatrix3D.idct3(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix3D)doubleMatrix3D).idct3(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix3D)doubleMatrix3D).assign(a_3d);
                t.reset().start();
                ((DenseDoubleMatrix3D)doubleMatrix3D).idct3(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idct3(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdct2Slices() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix3D.idct2Slices(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix3D.assign(a_3d);
                t.reset().start();
                denseDoubleMatrix3D.idct2Slices(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix3D)doubleMatrix3D).idct2Slices(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix3D)doubleMatrix3D).assign(a_3d);
                t.reset().start();
                ((DenseDoubleMatrix3D)doubleMatrix3D).idct2Slices(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idct2Slices(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdst3() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix3D.idst3(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix3D.assign(a_3d);
                t.reset().start();
                denseDoubleMatrix3D.idst3(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix3D)doubleMatrix3D).idst3(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix3D)doubleMatrix3D).assign(a_3d);
                t.reset().start();
                ((DenseDoubleMatrix3D)doubleMatrix3D).idst3(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idst3(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdst2Slices() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix3D.idst2Slices(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix3D.assign(a_3d);
                t.reset().start();
                denseDoubleMatrix3D.idst2Slices(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix3D)doubleMatrix3D).idst2Slices(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix3D)doubleMatrix3D).assign(a_3d);
                t.reset().start();
                ((DenseDoubleMatrix3D)doubleMatrix3D).idst2Slices(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idst2Slices(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdht3() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix3D.idht3(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix3D.assign(a_3d);
                t.reset().start();
                denseDoubleMatrix3D.idht3(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix3D)doubleMatrix3D).idht3(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix3D)doubleMatrix3D).assign(a_3d);
                t.reset().start();
                ((DenseDoubleMatrix3D)doubleMatrix3D).idht3(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idht3(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdht2Slices() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix3D.idht2Slices(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix3D.assign(a_3d);
                t.reset().start();
                denseDoubleMatrix3D.idht2Slices(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix3D)doubleMatrix3D).idht2Slices(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix3D)doubleMatrix3D).assign(a_3d);
                t.reset().start();
                ((DenseDoubleMatrix3D)doubleMatrix3D).idht2Slices(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idht2Slices(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfft3() {
        int n;
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDoubleMatrix3D.ifft3(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDoubleMatrix3D.assign(a_3d);
                t.reset().start();
                denseDoubleMatrix3D.ifft3(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDoubleMatrix3D)doubleMatrix3D).ifft3(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseDoubleMatrix3D)doubleMatrix3D).assign(a_3d);
                t.reset().start();
                ((DenseDoubleMatrix3D)doubleMatrix3D).ifft3(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "ifft3(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testMaxLocation() {
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double[] dArray = denseDoubleMatrix3D.getMaxLocation();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = denseDoubleMatrix3D.getMaxLocation();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double[] dArray = ((DenseDoubleMatrix3D)doubleMatrix3D).getMaxLocation();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = ((DenseDoubleMatrix3D)doubleMatrix3D).getMaxLocation();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "maxLocation()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testMinLocation() {
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double[] dArray = denseDoubleMatrix3D.getMinLocation();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = denseDoubleMatrix3D.getMinLocation();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double[] dArray = ((DenseDoubleMatrix3D)doubleMatrix3D).getMinLocation();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = ((DenseDoubleMatrix3D)doubleMatrix3D).getMinLocation();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "minLocation()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testSum() {
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double d = denseDoubleMatrix3D.zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = denseDoubleMatrix3D.zSum();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double d = ((DenseDoubleMatrix3D)doubleMatrix3D).zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                d = ((DenseDoubleMatrix3D)doubleMatrix3D).zSum();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zSum()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testToArray() {
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double[][][] dArray = denseDoubleMatrix3D.toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = denseDoubleMatrix3D.toArray();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double[][][] dArray = ((DenseDoubleMatrix3D)doubleMatrix3D).toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = ((DenseDoubleMatrix3D)doubleMatrix3D).toArray();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "toArray()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testVectorize() {
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            DoubleMatrix1D doubleMatrix1D = denseDoubleMatrix3D.vectorize();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                doubleMatrix1D = denseDoubleMatrix3D.vectorize();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            DoubleMatrix1D doubleMatrix1D = ((DenseDoubleMatrix3D)doubleMatrix3D).vectorize();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                doubleMatrix1D = ((DenseDoubleMatrix3D)doubleMatrix3D).vectorize();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "vectorize()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }
}

