/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import edu.emory.mathcs.csparsej.tdouble.Dcs_chol;
import edu.emory.mathcs.csparsej.tdouble.Dcs_common;
import edu.emory.mathcs.csparsej.tdouble.Dcs_ipvec;
import edu.emory.mathcs.csparsej.tdouble.Dcs_lsolve;
import edu.emory.mathcs.csparsej.tdouble.Dcs_ltsolve;
import edu.emory.mathcs.csparsej.tdouble.Dcs_pvec;
import edu.emory.mathcs.csparsej.tdouble.Dcs_schol;

public class SparseDoubleCholeskyDecomposition {
    private Dcs_common.Dcss S;
    private Dcs_common.Dcsn N;
    private DoubleMatrix2D L;
    private boolean rcMatrix = false;
    private int n;

    public SparseDoubleCholeskyDecomposition(DoubleMatrix2D doubleMatrix2D, int n) {
        Dcs_common.Dcs dcs;
        DoubleProperty.DEFAULT.checkSquare(doubleMatrix2D);
        DoubleProperty.DEFAULT.checkSparse(doubleMatrix2D);
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("order must be equal 0 or 1");
        }
        if (doubleMatrix2D instanceof SparseRCDoubleMatrix2D) {
            this.rcMatrix = true;
            dcs = ((SparseRCDoubleMatrix2D)doubleMatrix2D).getColumnCompressed().elements();
        } else {
            dcs = (Dcs_common.Dcs)doubleMatrix2D.elements();
        }
        this.n = doubleMatrix2D.rows();
        this.S = Dcs_schol.cs_schol((int)n, (Dcs_common.Dcs)dcs);
        if (this.S == null) {
            throw new IllegalArgumentException("Exception occured in cs_schol()");
        }
        this.N = Dcs_chol.cs_chol((Dcs_common.Dcs)dcs, (Dcs_common.Dcss)this.S);
        if (this.N == null) {
            throw new IllegalArgumentException("Matrix is not symmetric positive definite");
        }
    }

    public DoubleMatrix2D getL() {
        if (this.L == null) {
            this.L = new SparseCCDoubleMatrix2D(this.N.L);
            if (this.rcMatrix) {
                this.L = ((SparseCCDoubleMatrix2D)this.L).getRowCompressed();
            }
        }
        return this.L.copy();
    }

    public DoubleMatrix2D getLtranspose() {
        if (this.L == null) {
            this.L = new SparseCCDoubleMatrix2D(this.N.L);
            if (this.rcMatrix) {
                this.L = ((SparseCCDoubleMatrix2D)this.L).getRowCompressed();
            }
        }
        if (this.rcMatrix) {
            return ((SparseRCDoubleMatrix2D)this.L).getTranspose();
        }
        return ((SparseCCDoubleMatrix2D)this.L).getTranspose();
    }

    public Dcs_common.Dcss getSymbolicAnalysis() {
        Dcs_common.Dcss dcss = new Dcs_common.Dcss();
        dcss.cp = this.S.cp != null ? (int[])this.S.cp.clone() : null;
        dcss.leftmost = this.S.leftmost != null ? (int[])this.S.leftmost.clone() : null;
        dcss.lnz = this.S.lnz;
        dcss.m2 = this.S.m2;
        dcss.parent = this.S.parent != null ? (int[])this.S.parent.clone() : null;
        dcss.pinv = this.S.pinv != null ? (int[])this.S.pinv.clone() : null;
        dcss.q = this.S.q != null ? (int[])this.S.q.clone() : null;
        dcss.unz = this.S.unz;
        return dcss;
    }

    public void solve(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D.size() != (long)this.n) {
            throw new IllegalArgumentException("b.size() != A.rows()");
        }
        DoubleProperty.DEFAULT.checkDense(doubleMatrix1D);
        double[] dArray = new double[this.n];
        double[] dArray2 = doubleMatrix1D.isView() ? (double[])doubleMatrix1D.copy().elements() : (double[])doubleMatrix1D.elements();
        Dcs_ipvec.cs_ipvec((int[])this.S.pinv, (double[])dArray2, (double[])dArray, (int)this.n);
        Dcs_lsolve.cs_lsolve((Dcs_common.Dcs)this.N.L, (double[])dArray);
        Dcs_ltsolve.cs_ltsolve((Dcs_common.Dcs)this.N.L, (double[])dArray);
        Dcs_pvec.cs_pvec((int[])this.S.pinv, (double[])dArray, (double[])dArray2, (int)this.n);
        if (doubleMatrix1D.isView()) {
            doubleMatrix1D.assign(dArray2);
        }
    }
}

