/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.algo;

import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.tlong.LongFactory2D;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.jet.math.tlong.LongFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class LongProperty
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final LongProperty DEFAULT = new LongProperty();

    protected static String blanks(int n) {
        if (n < 0) {
            n = 0;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public void checkRectangular(LongMatrix2D longMatrix2D) {
        if (longMatrix2D.rows() < longMatrix2D.columns()) {
            throw new IllegalArgumentException("Matrix must be rectangular: " + AbstractFormatter.shape(longMatrix2D));
        }
    }

    public void checkSquare(LongMatrix2D longMatrix2D) {
        if (longMatrix2D.rows() != longMatrix2D.columns()) {
            throw new IllegalArgumentException("Matrix must be square: " + AbstractFormatter.shape(longMatrix2D));
        }
    }

    public int density(LongMatrix2D longMatrix2D) {
        return longMatrix2D.cardinality() / (int)longMatrix2D.size();
    }

    public boolean equals(final LongMatrix1D longMatrix1D, final long l) {
        if (longMatrix1D == null) {
            return false;
        }
        int n = (int)longMatrix1D.size();
        boolean bl = false;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            Boolean[] booleanArray = new Boolean[n2];
            int n4 = n / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? n : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = n5; i < n6; ++i) {
                            if (longMatrix1D.getQuick(i) == l) continue;
                            return false;
                        }
                        return true;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    booleanArray[n3] = (Boolean)futureArray[n3].get();
                }
                bl = booleanArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    bl = bl && booleanArray[n3] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        for (int i = 0; i < n; ++i) {
            if (longMatrix1D.getQuick(i) == l) continue;
            return false;
        }
        return true;
    }

    public boolean equals(final LongMatrix1D longMatrix1D, final LongMatrix1D longMatrix1D2) {
        if (longMatrix1D == longMatrix1D2) {
            return true;
        }
        if (longMatrix1D == null || longMatrix1D2 == null) {
            return false;
        }
        int n = (int)longMatrix1D.size();
        if ((long)n != longMatrix1D2.size()) {
            return false;
        }
        boolean bl = false;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            Boolean[] booleanArray = new Boolean[n2];
            int n4 = n / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? n : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = n5; i < n6; ++i) {
                            if (longMatrix1D.getQuick(i) == longMatrix1D2.getQuick(i)) continue;
                            return false;
                        }
                        return true;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    booleanArray[n3] = (Boolean)futureArray[n3].get();
                }
                bl = booleanArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    bl = bl && booleanArray[n3] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        for (int i = 0; i < n; ++i) {
            if (longMatrix1D.getQuick(i) == longMatrix1D2.getQuick(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(final LongMatrix2D longMatrix2D, final long l) {
        if (longMatrix2D == null) {
            return false;
        }
        int n = longMatrix2D.rows();
        final int n2 = longMatrix2D.columns();
        boolean bl = false;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && longMatrix2D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n3 = Math.min(n3, longMatrix2D.rows());
            Future[] futureArray = new Future[n3];
            Boolean[] booleanArray = new Boolean[n3];
            int n5 = longMatrix2D.rows() / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? longMatrix2D.rows() : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < n2; ++j) {
                                if (longMatrix2D.getQuick(i, j) == l) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    booleanArray[n4] = (Boolean)futureArray[n4].get();
                }
                bl = booleanArray[0];
                for (n4 = 1; n4 < n3; ++n4) {
                    bl = bl && booleanArray[n4] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (longMatrix2D.getQuick(i, j) == l) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(final LongMatrix2D longMatrix2D, final LongMatrix2D longMatrix2D2) {
        if (longMatrix2D == longMatrix2D2) {
            return true;
        }
        if (longMatrix2D == null || longMatrix2D2 == null) {
            return false;
        }
        int n = longMatrix2D.rows();
        final int n2 = longMatrix2D.columns();
        if (n2 != longMatrix2D2.columns() || n != longMatrix2D2.rows()) {
            return false;
        }
        boolean bl = false;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && longMatrix2D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n3 = Math.min(n3, longMatrix2D.rows());
            Future[] futureArray = new Future[n3];
            Boolean[] booleanArray = new Boolean[n3];
            int n5 = longMatrix2D.rows() / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? longMatrix2D.rows() : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < n2; ++j) {
                                if (longMatrix2D.getQuick(i, j) == longMatrix2D2.getQuick(i, j)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    booleanArray[n4] = (Boolean)futureArray[n4].get();
                }
                bl = booleanArray[0];
                for (n4 = 1; n4 < n3; ++n4) {
                    bl = bl && booleanArray[n4] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (longMatrix2D.getQuick(i, j) == longMatrix2D2.getQuick(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(final LongMatrix3D longMatrix3D, final long l) {
        if (longMatrix3D == null) {
            return false;
        }
        int n = longMatrix3D.slices();
        final int n2 = longMatrix3D.rows();
        final int n3 = longMatrix3D.columns();
        boolean bl = false;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && longMatrix3D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n5;
            n4 = Math.min(n4, n);
            Future[] futureArray = new Future[n4];
            Boolean[] booleanArray = new Boolean[n4];
            int n6 = n / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? n : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = n7; i < n8; ++i) {
                            for (int j = 0; j < n2; ++j) {
                                for (int k = 0; k < n3; ++k) {
                                    if (longMatrix3D.getQuick(i, j, k) == l) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    booleanArray[n5] = (Boolean)futureArray[n5].get();
                }
                bl = booleanArray[0];
                for (n5 = 1; n5 < n4; ++n5) {
                    bl = bl && booleanArray[n5] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    if (longMatrix3D.getQuick(i, j, k) == l) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(final LongMatrix3D longMatrix3D, final LongMatrix3D longMatrix3D2) {
        if (longMatrix3D == longMatrix3D2) {
            return true;
        }
        if (longMatrix3D == null || longMatrix3D2 == null) {
            return false;
        }
        int n = longMatrix3D.slices();
        final int n2 = longMatrix3D.rows();
        final int n3 = longMatrix3D.columns();
        if (n3 != longMatrix3D2.columns() || n2 != longMatrix3D2.rows() || n != longMatrix3D2.slices()) {
            return false;
        }
        boolean bl = false;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && longMatrix3D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n5;
            n4 = Math.min(n4, n);
            Future[] futureArray = new Future[n4];
            Boolean[] booleanArray = new Boolean[n4];
            int n6 = n / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? n : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = n7; i < n8; ++i) {
                            for (int j = 0; j < n2; ++j) {
                                for (int k = 0; k < n3; ++k) {
                                    if (longMatrix3D.getQuick(i, j, k) == longMatrix3D2.getQuick(i, j, k)) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    booleanArray[n5] = (Boolean)futureArray[n5].get();
                }
                bl = booleanArray[0];
                for (n5 = 1; n5 < n4; ++n5) {
                    bl = bl && booleanArray[n5] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    if (longMatrix3D.getQuick(i, j, k) == longMatrix3D2.getQuick(i, j, k)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateNonSingular(LongMatrix2D longMatrix2D) {
        int n;
        this.checkSquare(longMatrix2D);
        LongFunctions longFunctions = LongFunctions.longFunctions;
        int n2 = n = Math.min(longMatrix2D.rows(), longMatrix2D.columns());
        while (--n2 >= 0) {
            longMatrix2D.setQuick(n2, n2, 0L);
        }
        n2 = n;
        while (--n2 >= 0) {
            long l = longMatrix2D.viewRow(n2).aggregate(LongFunctions.plus, LongFunctions.abs);
            long l2 = longMatrix2D.viewColumn(n2).aggregate(LongFunctions.plus, LongFunctions.abs);
            longMatrix2D.setQuick(n2, n2, Math.max(l, l2) + (long)n2 + 1L);
        }
    }

    protected static String get(ObjectArrayList objectArrayList, int n) {
        return (String)objectArrayList.get(n);
    }

    public boolean isDiagonal(LongMatrix2D longMatrix2D) {
        int n = longMatrix2D.rows();
        int n2 = longMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (n3 == n4 || longMatrix2D.getQuick(n3, n4) == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDiagonallyDominantByColumn(LongMatrix2D longMatrix2D) {
        int n;
        LongFunctions longFunctions = LongFunctions.longFunctions;
        int n2 = n = Math.min(longMatrix2D.rows(), longMatrix2D.columns());
        while (--n2 >= 0) {
            long l = Math.abs(longMatrix2D.getQuick(n2, n2));
            if ((l += l) > longMatrix2D.viewColumn(n2).aggregate(LongFunctions.plus, LongFunctions.abs)) continue;
            return false;
        }
        return true;
    }

    public boolean isDiagonallyDominantByRow(LongMatrix2D longMatrix2D) {
        int n;
        LongFunctions longFunctions = LongFunctions.longFunctions;
        int n2 = n = Math.min(longMatrix2D.rows(), longMatrix2D.columns());
        while (--n2 >= 0) {
            long l = Math.abs(longMatrix2D.getQuick(n2, n2));
            if ((l += l) > longMatrix2D.viewRow(n2).aggregate(LongFunctions.plus, LongFunctions.abs)) continue;
            return false;
        }
        return true;
    }

    public boolean isIdentity(LongMatrix2D longMatrix2D) {
        int n = longMatrix2D.rows();
        int n2 = longMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                long l = longMatrix2D.getQuick(n3, n4);
                if (!(n3 == n4 ? l != 1L : l != 0L)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerBidiagonal(LongMatrix2D longMatrix2D) {
        int n = longMatrix2D.rows();
        int n2 = longMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (n3 == n4 || n3 == n4 + 1 || longMatrix2D.getQuick(n3, n4) == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerTriangular(LongMatrix2D longMatrix2D) {
        int n;
        int n2 = longMatrix2D.rows();
        int n3 = n = longMatrix2D.columns();
        while (--n3 >= 0) {
            int n4 = Math.min(n3, n2);
            while (--n4 >= 0) {
                if (longMatrix2D.getQuick(n4, n3) == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isNonNegative(LongMatrix2D longMatrix2D) {
        int n = longMatrix2D.rows();
        int n2 = longMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (longMatrix2D.getQuick(n3, n4) >= 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isOrthogonal(LongMatrix2D longMatrix2D) {
        this.checkSquare(longMatrix2D);
        return this.equals(longMatrix2D.zMult(longMatrix2D, null, 1L, 0L, false, true), LongFactory2D.dense.identity(longMatrix2D.rows()));
    }

    public boolean isPositive(LongMatrix2D longMatrix2D) {
        int n = longMatrix2D.rows();
        int n2 = longMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (longMatrix2D.getQuick(n3, n4) > 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSkewSymmetric(LongMatrix2D longMatrix2D) {
        this.checkSquare(longMatrix2D);
        int n = longMatrix2D.rows();
        int n2 = longMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n;
            while (--n4 >= 0) {
                if (longMatrix2D.getQuick(n3, n4) == -longMatrix2D.getQuick(n4, n3)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSquare(LongMatrix2D longMatrix2D) {
        return longMatrix2D.rows() == longMatrix2D.columns();
    }

    public boolean isStrictlyLowerTriangular(LongMatrix2D longMatrix2D) {
        int n;
        int n2 = longMatrix2D.rows();
        int n3 = n = longMatrix2D.columns();
        while (--n3 >= 0) {
            int n4 = Math.min(n2, n3 + 1);
            while (--n4 >= 0) {
                if (longMatrix2D.getQuick(n4, n3) == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isStrictlyTriangular(LongMatrix2D longMatrix2D) {
        if (!this.isTriangular(longMatrix2D)) {
            return false;
        }
        int n = Math.min(longMatrix2D.rows(), longMatrix2D.columns());
        while (--n >= 0) {
            if (longMatrix2D.getQuick(n, n) == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean isStrictlyUpperTriangular(LongMatrix2D longMatrix2D) {
        int n;
        int n2 = longMatrix2D.rows();
        int n3 = n = longMatrix2D.columns();
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= n3) {
                if (longMatrix2D.getQuick(n4, n3) == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSymmetric(LongMatrix2D longMatrix2D) {
        this.checkSquare(longMatrix2D);
        return this.equals(longMatrix2D, longMatrix2D.viewDice());
    }

    public boolean isTriangular(LongMatrix2D longMatrix2D) {
        return this.isLowerTriangular(longMatrix2D) || this.isUpperTriangular(longMatrix2D);
    }

    public boolean isTridiagonal(LongMatrix2D longMatrix2D) {
        int n = longMatrix2D.rows();
        int n2 = longMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (Math.abs(n3 - n4) <= 1 || longMatrix2D.getQuick(n3, n4) == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUnitTriangular(LongMatrix2D longMatrix2D) {
        if (!this.isTriangular(longMatrix2D)) {
            return false;
        }
        int n = Math.min(longMatrix2D.rows(), longMatrix2D.columns());
        while (--n >= 0) {
            if (longMatrix2D.getQuick(n, n) == 1L) continue;
            return false;
        }
        return true;
    }

    public boolean isUpperBidiagonal(LongMatrix2D longMatrix2D) {
        int n = longMatrix2D.rows();
        int n2 = longMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (n3 == n4 || n3 == n4 - 1 || longMatrix2D.getQuick(n3, n4) == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUpperTriangular(LongMatrix2D longMatrix2D) {
        int n;
        int n2 = longMatrix2D.rows();
        int n3 = n = longMatrix2D.columns();
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 > n3) {
                if (longMatrix2D.getQuick(n4, n3) == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isZero(LongMatrix2D longMatrix2D) {
        return this.equals(longMatrix2D, 0L);
    }

    public int lowerBandwidth(LongMatrix2D longMatrix2D) {
        int n;
        this.checkSquare(longMatrix2D);
        int n2 = n = longMatrix2D.rows();
        while (--n2 >= 0) {
            int n3 = n - n2;
            while (--n3 >= 0) {
                int n4 = n3 + n2;
                if (longMatrix2D.getQuick(n4, n3) == 0L) continue;
                return n2;
            }
        }
        return 0;
    }

    public int semiBandwidth(LongMatrix2D longMatrix2D) {
        int n;
        this.checkSquare(longMatrix2D);
        int n2 = n = longMatrix2D.rows();
        while (--n2 >= 0) {
            int n3 = n - n2;
            while (--n3 >= 0) {
                int n4 = n3 + n2;
                if (longMatrix2D.getQuick(n4, n3) != 0L) {
                    return n2 + 1;
                }
                if (longMatrix2D.getQuick(n3, n4) == 0L) continue;
                return n2 + 1;
            }
        }
        return 1;
    }

    public String toString(LongMatrix2D longMatrix2D) {
        int n;
        final ObjectArrayList objectArrayList = new ObjectArrayList();
        final ObjectArrayList objectArrayList2 = new ObjectArrayList();
        String string = "Illegal operation or error: ";
        objectArrayList.add("density");
        try {
            objectArrayList2.add(String.valueOf(this.density(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isDiagonal");
        try {
            objectArrayList2.add(String.valueOf(this.isDiagonal(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isDiagonallyDominantByRow");
        try {
            objectArrayList2.add(String.valueOf(this.isDiagonallyDominantByRow(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isDiagonallyDominantByColumn");
        try {
            objectArrayList2.add(String.valueOf(this.isDiagonallyDominantByColumn(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isIdentity");
        try {
            objectArrayList2.add(String.valueOf(this.isIdentity(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isLowerBidiagonal");
        try {
            objectArrayList2.add(String.valueOf(this.isLowerBidiagonal(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isLowerTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isLowerTriangular(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isNonNegative");
        try {
            objectArrayList2.add(String.valueOf(this.isNonNegative(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isOrthogonal");
        try {
            objectArrayList2.add(String.valueOf(this.isOrthogonal(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isPositive");
        try {
            objectArrayList2.add(String.valueOf(this.isPositive(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isSkewSymmetric");
        try {
            objectArrayList2.add(String.valueOf(this.isSkewSymmetric(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isSquare");
        try {
            objectArrayList2.add(String.valueOf(this.isSquare(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isStrictlyLowerTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isStrictlyLowerTriangular(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isStrictlyTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isStrictlyTriangular(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isStrictlyUpperTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isStrictlyUpperTriangular(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isSymmetric");
        try {
            objectArrayList2.add(String.valueOf(this.isSymmetric(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isTriangular(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isTridiagonal");
        try {
            objectArrayList2.add(String.valueOf(this.isTridiagonal(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isUnitTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isUnitTriangular(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isUpperBidiagonal");
        try {
            objectArrayList2.add(String.valueOf(this.isUpperBidiagonal(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isUpperTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isUpperTriangular(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isZero");
        try {
            objectArrayList2.add(String.valueOf(this.isZero(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("lowerBandwidth");
        try {
            objectArrayList2.add(String.valueOf(this.lowerBandwidth(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("semiBandwidth");
        try {
            objectArrayList2.add(String.valueOf(this.semiBandwidth(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("upperBandwidth");
        try {
            objectArrayList2.add(String.valueOf(this.upperBandwidth(longMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return LongProperty.get(objectArrayList, n).compareTo(LongProperty.get(objectArrayList, n2));
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                Object object = objectArrayList.get(n);
                objectArrayList.set(n, objectArrayList.get(n2));
                objectArrayList.set(n2, object);
                object = objectArrayList2.get(n);
                objectArrayList2.set(n, objectArrayList2.get(n2));
                objectArrayList2.set(n2, object);
            }
        };
        GenericSorting.quickSort(0, objectArrayList.size(), intComparator, swapper);
        int n2 = 0;
        for (int i = 0; i < objectArrayList.size(); ++i) {
            n = ((String)objectArrayList.get(i)).length();
            n2 = Math.max(n, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < objectArrayList.size(); ++n) {
            String string2 = (String)objectArrayList.get(n);
            stringBuffer.append(string2);
            stringBuffer.append(LongProperty.blanks(n2 - string2.length()));
            stringBuffer.append(" : ");
            stringBuffer.append(objectArrayList2.get(n));
            if (n >= objectArrayList.size() - 1) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public int upperBandwidth(LongMatrix2D longMatrix2D) {
        int n;
        this.checkSquare(longMatrix2D);
        int n2 = n = longMatrix2D.rows();
        while (--n2 >= 0) {
            int n3 = n - n2;
            while (--n3 >= 0) {
                int n4 = n3 + n2;
                if (longMatrix2D.getQuick(n3, n4) == 0L) continue;
                return n2;
            }
        }
        return 0;
    }
}

