/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.algo.FComplexProperty;
import cern.colt.matrix.tfcomplex.impl.DelegateFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.DenseLargeFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DiagonalFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseLargeFloatMatrix2D;
import cern.jet.math.tfcomplex.FComplex;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class WrapperFComplexMatrix2D
extends FComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected FComplexMatrix2D content;

    public WrapperFComplexMatrix2D(FComplexMatrix2D fComplexMatrix2D) {
        if (fComplexMatrix2D != null) {
            this.setUp(fComplexMatrix2D.rows(), fComplexMatrix2D.columns());
        }
        this.content = fComplexMatrix2D;
    }

    public FComplexMatrix2D assign(final float[] fArray) {
        if (this.content instanceof DiagonalFComplexMatrix2D) {
            int n = ((DiagonalFComplexMatrix2D)this.content).dlength;
            final float[] fArray2 = ((DiagonalFComplexMatrix2D)this.content).elements;
            if (fArray.length != 2 * n) {
                throw new IllegalArgumentException("Must have same length: length=" + fArray.length + " 2 * dlength=" + 2 * n);
            }
            int n2 = ConcurrencyUtils.getNumberOfThreads();
            if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n2 = Math.min(n2, n);
                Future[] futureArray = new Future[n2];
                int n3 = n / n2;
                for (int i = 0; i < n2; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n2 - 1 ? n : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n4; i < n5; ++i) {
                                fArray2[2 * i] = fArray[2 * i];
                                fArray2[2 * i + 1] = fArray[2 * i + 1];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < n; ++i) {
                    fArray2[2 * i] = fArray[2 * i];
                    fArray2[2 * i + 1] = fArray[2 * i + 1];
                }
            }
            return this;
        }
        return super.assign(fArray);
    }

    public boolean equals(float[] fArray) {
        if (this.content instanceof DiagonalFComplexMatrix2D) {
            float f = FComplexProperty.DEFAULT.tolerance();
            float[] fArray2 = (float[])this.content.elements();
            int n = ((DiagonalFComplexMatrix2D)this.content).dlength;
            float[] fArray3 = new float[2];
            float[] fArray4 = new float[2];
            for (int i = 0; i < n; ++i) {
                fArray3[0] = fArray2[2 * i];
                fArray3[1] = fArray2[2 * i + 1];
                fArray4[0] = Math.abs(fArray[0] - fArray3[0]);
                fArray4[1] = Math.abs(fArray[1] - fArray3[1]);
                if (!((fArray4[0] == fArray4[0] && fArray4[1] == fArray4[1] || fArray[0] == fArray[0] && fArray[1] == fArray[1] || fArray3[0] == fArray3[0] && fArray3[1] == fArray3[1]) && !FComplex.isEqual(fArray, fArray3, f))) {
                    fArray4[0] = 0.0f;
                    fArray4[1] = 0.0f;
                }
                if (!(fArray4[0] > f) && !(fArray4[1] > f)) continue;
                return false;
            }
            return true;
        }
        return super.equals(fArray);
    }

    public boolean equals(Object object) {
        if (this.content instanceof DiagonalFComplexMatrix2D && object instanceof DiagonalFComplexMatrix2D) {
            DiagonalFComplexMatrix2D diagonalFComplexMatrix2D = (DiagonalFComplexMatrix2D)object;
            int n = ((DiagonalFComplexMatrix2D)this.content).dlength;
            float f = FComplexProperty.DEFAULT.tolerance();
            if (this == object) {
                return true;
            }
            if (this == null || object == null) {
                return false;
            }
            DiagonalFComplexMatrix2D diagonalFComplexMatrix2D2 = (DiagonalFComplexMatrix2D)this.content;
            DiagonalFComplexMatrix2D diagonalFComplexMatrix2D3 = (DiagonalFComplexMatrix2D)object;
            if (diagonalFComplexMatrix2D2.columns() != diagonalFComplexMatrix2D3.columns() || diagonalFComplexMatrix2D2.rows() != diagonalFComplexMatrix2D3.rows() || diagonalFComplexMatrix2D2.diagonalIndex() != diagonalFComplexMatrix2D3.diagonalIndex() || diagonalFComplexMatrix2D2.diagonalLength() != diagonalFComplexMatrix2D3.diagonalLength()) {
                return false;
            }
            float[] fArray = diagonalFComplexMatrix2D.elements;
            float[] fArray2 = ((DiagonalFComplexMatrix2D)this.content).elements;
            float[] fArray3 = new float[2];
            float[] fArray4 = new float[2];
            float[] fArray5 = new float[2];
            for (int i = 0; i < n; ++i) {
                fArray3[0] = fArray2[2 * i];
                fArray3[1] = fArray2[2 * i + 1];
                fArray4[0] = fArray[2 * i];
                fArray4[1] = fArray[2 * i + 1];
                fArray5[0] = Math.abs(fArray4[0] - fArray3[0]);
                fArray5[1] = Math.abs(fArray4[1] - fArray3[1]);
                if (!((fArray5[0] == fArray5[0] && fArray5[1] == fArray5[1] || fArray4[0] == fArray4[0] && fArray4[1] == fArray4[1] || fArray3[0] == fArray3[0] && fArray3[1] == fArray3[1]) && !FComplex.isEqual(fArray4, fArray3, f))) {
                    fArray5[0] = 0.0f;
                    fArray5[1] = 0.0f;
                }
                if (!(fArray5[0] > f) && !(fArray5[1] > f)) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    public Object elements() {
        return this.content.elements();
    }

    public synchronized float[] getQuick(int n, int n2) {
        return this.content.getQuick(n, n2);
    }

    public FComplexMatrix2D like(int n, int n2) {
        return this.content.like(n, n2);
    }

    public FComplexMatrix1D like1D(int n) {
        return this.content.like1D(n);
    }

    public void fft2() {
        if (this.content instanceof DenseLargeFComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix2D)this.content).fft2();
            } else {
                DenseLargeFComplexMatrix2D denseLargeFComplexMatrix2D = (DenseLargeFComplexMatrix2D)this.copy();
                denseLargeFComplexMatrix2D.fft2();
                this.assign(denseLargeFComplexMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void fftColumns() {
        if (this.content instanceof DenseLargeFComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix2D)this.content).fftColumns();
            } else {
                DenseLargeFComplexMatrix2D denseLargeFComplexMatrix2D = (DenseLargeFComplexMatrix2D)this.copy();
                denseLargeFComplexMatrix2D.fftColumns();
                this.assign(denseLargeFComplexMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void fftRows() {
        if (this.content instanceof DenseLargeFComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix2D)this.content).fftRows();
            } else {
                DenseLargeFComplexMatrix2D denseLargeFComplexMatrix2D = (DenseLargeFComplexMatrix2D)this.copy();
                denseLargeFComplexMatrix2D.fftRows();
                this.assign(denseLargeFComplexMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifftColumns(boolean bl) {
        if (this.content instanceof DenseLargeFComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix2D)this.content).ifftColumns(bl);
            } else {
                DenseLargeFComplexMatrix2D denseLargeFComplexMatrix2D = (DenseLargeFComplexMatrix2D)this.copy();
                denseLargeFComplexMatrix2D.ifftColumns(bl);
                this.assign(denseLargeFComplexMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifftRows(boolean bl) {
        if (this.content instanceof DenseLargeFComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix2D)this.content).ifftRows(bl);
            } else {
                DenseLargeFComplexMatrix2D denseLargeFComplexMatrix2D = (DenseLargeFComplexMatrix2D)this.copy();
                denseLargeFComplexMatrix2D.ifftRows(bl);
                this.assign(denseLargeFComplexMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifft2(boolean bl) {
        if (this.content instanceof DenseLargeFComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix2D)this.content).ifft2(bl);
            } else {
                DenseLargeFComplexMatrix2D denseLargeFComplexMatrix2D = (DenseLargeFComplexMatrix2D)this.copy();
                denseLargeFComplexMatrix2D.ifft2(bl);
                this.assign(denseLargeFComplexMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public synchronized void setQuick(int n, int n2, float[] fArray) {
        this.content.setQuick(n, n2, fArray);
    }

    public synchronized void setQuick(int n, int n2, float f, float f2) {
        this.content.setQuick(n, n2, f, f2);
    }

    public FComplexMatrix1D vectorize() {
        final DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D((int)this.size());
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3 * WrapperFComplexMatrix2D.this.rows;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < WrapperFComplexMatrix2D.this.rows; ++j) {
                                denseFComplexMatrix1D.setQuick(n++, WrapperFComplexMatrix2D.this.getQuick(j, i));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = 0;
            for (int i = 0; i < this.columns; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    denseFComplexMatrix1D.setQuick(n5++, this.getQuick(j, i));
                }
            }
        }
        return denseFComplexMatrix1D;
    }

    public FComplexMatrix1D viewColumn(int n) {
        return this.viewDice().viewRow(n);
    }

    public FComplexMatrix2D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperFComplexMatrix2D wrapperFComplexMatrix2D = new WrapperFComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int n, int n2) {
                return this.content.getQuick(n, this.columns - 1 - n2);
            }

            public synchronized void setQuick(int n, int n2, float[] fArray) {
                this.content.setQuick(n, this.columns - 1 - n2, fArray);
            }

            public synchronized void setQuick(int n, int n2, float f, float f2) {
                this.content.setQuick(n, this.columns - 1 - n2, f, f2);
            }

            public synchronized float[] get(int n, int n2) {
                return this.content.get(n, this.columns - 1 - n2);
            }

            public synchronized void set(int n, int n2, float[] fArray) {
                this.content.set(n, this.columns - 1 - n2, fArray);
            }

            public synchronized void set(int n, int n2, float f, float f2) {
                this.content.set(n, this.columns - 1 - n2, f, f2);
            }
        };
        wrapperFComplexMatrix2D.isNoView = false;
        return wrapperFComplexMatrix2D;
    }

    public FComplexMatrix2D viewDice() {
        WrapperFComplexMatrix2D wrapperFComplexMatrix2D = new WrapperFComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int n, int n2) {
                return this.content.getQuick(n2, n);
            }

            public synchronized void setQuick(int n, int n2, float[] fArray) {
                this.content.setQuick(n2, n, fArray);
            }

            public synchronized void setQuick(int n, int n2, float f, float f2) {
                this.content.setQuick(n2, n, f, f2);
            }

            public synchronized float[] get(int n, int n2) {
                return this.content.get(n2, n);
            }

            public synchronized void set(int n, int n2, float[] fArray) {
                this.content.set(n2, n, fArray);
            }

            public synchronized void set(int n, int n2, float f, float f2) {
                this.content.set(n2, n, f, f2);
            }
        };
        wrapperFComplexMatrix2D.rows = this.columns;
        wrapperFComplexMatrix2D.columns = this.rows;
        wrapperFComplexMatrix2D.isNoView = false;
        return wrapperFComplexMatrix2D;
    }

    public FComplexMatrix2D viewPart(final int n, final int n2, int n3, int n4) {
        this.checkBox(n, n2, n3, n4);
        WrapperFComplexMatrix2D wrapperFComplexMatrix2D = new WrapperFComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int n3, int n22) {
                return this.content.getQuick(n + n3, n2 + n22);
            }

            public synchronized void setQuick(int n3, int n22, float[] fArray) {
                this.content.setQuick(n + n3, n2 + n22, fArray);
            }

            public synchronized void setQuick(int n3, int n22, float f, float f2) {
                this.content.setQuick(n + n3, n2 + n22, f, f2);
            }

            public synchronized float[] get(int n3, int n22) {
                return this.content.get(n + n3, n2 + n22);
            }

            public synchronized void set(int n3, int n22, float[] fArray) {
                this.content.set(n + n3, n2 + n22, fArray);
            }

            public synchronized void set(int n3, int n22, float f, float f2) {
                this.content.set(n + n3, n2 + n22, f, f2);
            }
        };
        wrapperFComplexMatrix2D.rows = n3;
        wrapperFComplexMatrix2D.columns = n4;
        wrapperFComplexMatrix2D.isNoView = false;
        return wrapperFComplexMatrix2D;
    }

    public FComplexMatrix1D viewRow(int n) {
        this.checkRow(n);
        return new DelegateFComplexMatrix1D(this, n);
    }

    public FComplexMatrix2D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperFComplexMatrix2D wrapperFComplexMatrix2D = new WrapperFComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int n, int n2) {
                return this.content.getQuick(this.rows - 1 - n, n2);
            }

            public synchronized void setQuick(int n, int n2, float[] fArray) {
                this.content.setQuick(this.rows - 1 - n, n2, fArray);
            }

            public synchronized void setQuick(int n, int n2, float f, float f2) {
                this.content.setQuick(this.rows - 1 - n, n2, f, f2);
            }

            public synchronized float[] get(int n, int n2) {
                return this.content.get(this.rows - 1 - n, n2);
            }

            public synchronized void set(int n, int n2, float[] fArray) {
                this.content.set(this.rows - 1 - n, n2, fArray);
            }

            public synchronized void set(int n, int n2, float f, float f2) {
                this.content.set(this.rows - 1 - n, n2, f, f2);
            }
        };
        wrapperFComplexMatrix2D.isNoView = false;
        return wrapperFComplexMatrix2D;
    }

    public FComplexMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null) {
            nArray = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        final int[] nArray3 = nArray;
        final int[] nArray4 = nArray2;
        WrapperFComplexMatrix2D wrapperFComplexMatrix2D = new WrapperFComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int n, int n2) {
                return this.content.getQuick(nArray3[n], nArray4[n2]);
            }

            public synchronized void setQuick(int n, int n2, float[] fArray) {
                this.content.setQuick(nArray3[n], nArray4[n2], fArray);
            }

            public synchronized void setQuick(int n, int n2, float f, float f2) {
                this.content.setQuick(nArray3[n], nArray4[n2], f, f2);
            }

            public synchronized float[] get(int n, int n2) {
                return this.content.get(nArray3[n], nArray4[n2]);
            }

            public synchronized void set(int n, int n2, float[] fArray) {
                this.content.set(nArray3[n], nArray4[n2], fArray);
            }

            public synchronized void set(int n, int n2, float f, float f2) {
                this.content.set(nArray3[n], nArray4[n2], f, f2);
            }
        };
        wrapperFComplexMatrix2D.rows = nArray.length;
        wrapperFComplexMatrix2D.columns = nArray2.length;
        wrapperFComplexMatrix2D.isNoView = false;
        return wrapperFComplexMatrix2D;
    }

    public FComplexMatrix2D viewStrides(final int n, final int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperFComplexMatrix2D wrapperFComplexMatrix2D = new WrapperFComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int n3, int n22) {
                return this.content.getQuick(n * n3, n2 * n22);
            }

            public synchronized void setQuick(int n3, int n22, float[] fArray) {
                this.content.setQuick(n * n3, n2 * n22, fArray);
            }

            public synchronized void setQuick(int n3, int n22, float f, float f2) {
                this.content.setQuick(n * n3, n2 * n22, f, f2);
            }

            public synchronized float[] get(int n3, int n22) {
                return this.content.get(n * n3, n2 * n22);
            }

            public synchronized void set(int n3, int n22, float[] fArray) {
                this.content.set(n * n3, n2 * n22, fArray);
            }

            public synchronized void set(int n3, int n22, float f, float f2) {
                this.content.set(n * n3, n2 * n22, f, f2);
            }
        };
        if (this.rows != 0) {
            wrapperFComplexMatrix2D.rows = (this.rows - 1) / n + 1;
        }
        if (this.columns != 0) {
            wrapperFComplexMatrix2D.columns = (this.columns - 1) / n2 + 1;
        }
        wrapperFComplexMatrix2D.isNoView = false;
        return wrapperFComplexMatrix2D;
    }

    protected FComplexMatrix2D getContent() {
        return this.content;
    }

    protected FComplexMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    protected FComplexMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        throw new InternalError();
    }

    public FloatMatrix2D getImaginaryPart() {
        final DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = new DenseLargeFloatMatrix2D(this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < WrapperFComplexMatrix2D.this.columns; ++j) {
                                denseLargeFloatMatrix2D.setQuick(i, j, WrapperFComplexMatrix2D.this.getQuick(i, j)[1]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    denseLargeFloatMatrix2D.setQuick(i, j, this.getQuick(i, j)[1]);
                }
            }
        }
        return denseLargeFloatMatrix2D;
    }

    public FloatMatrix2D getRealPart() {
        final DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = new DenseLargeFloatMatrix2D(this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < WrapperFComplexMatrix2D.this.columns; ++j) {
                                denseLargeFloatMatrix2D.setQuick(i, j, WrapperFComplexMatrix2D.this.getQuick(i, j)[0]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    denseLargeFloatMatrix2D.setQuick(i, j, this.getQuick(i, j)[0]);
                }
            }
        }
        return denseLargeFloatMatrix2D;
    }
}

