/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.io;

import cern.colt.matrix.io.MatrixInfo;

public class MatrixSize {
    private int numRows;
    private int numColumns;
    private int numEntries;

    public MatrixSize(int n, int n2, MatrixInfo matrixInfo) {
        this.numRows = n;
        this.numColumns = n2;
        if (!matrixInfo.isDense()) {
            throw new IllegalArgumentException("Matrix must be dense");
        }
        if (matrixInfo.isGeneral()) {
            this.numEntries = n * n2;
        } else if (matrixInfo.isSymmetric() || matrixInfo.isHermitian()) {
            this.numEntries = (n * n2 - n) / 2 + n;
        } else if (matrixInfo.isSkewSymmetric()) {
            this.numEntries = (n * n2 - n) / 2;
        }
    }

    public MatrixSize(int n, int n2, int n3) {
        this.numRows = n;
        this.numColumns = n2;
        this.numEntries = n3;
        long l = n;
        long l2 = n2;
        long l3 = l * l2;
        if ((long)n3 > l3) {
            throw new IllegalArgumentException("numEntries > numRows*numColumns");
        }
    }

    public int numRows() {
        return this.numRows;
    }

    public int numColumns() {
        return this.numColumns;
    }

    public int numEntries() {
        return this.numEntries;
    }

    public boolean isSquare() {
        return this.numRows == this.numColumns;
    }
}

