/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SelectedDenseLongMatrix3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseLongMatrix3D
extends LongMatrix3D {
    private static final long serialVersionUID = 1L;
    protected long[] elements;

    public DenseLongMatrix3D(long[][][] lArray) {
        this(lArray.length, lArray.length == 0 ? 0 : lArray[0].length, lArray.length == 0 ? 0 : (lArray[0].length == 0 ? 0 : lArray[0][0].length));
        this.assign(lArray);
    }

    public DenseLongMatrix3D(int n, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = new long[n * n2 * n3];
    }

    public DenseLongMatrix3D(int n, int n2, int n3, long[] lArray, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) {
        this.setUp(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.elements = lArray;
        this.isNoView = !bl;
    }

    public long aggregate(final LongLongFunction longLongFunction, final LongFunction longFunction) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        long l = 0L;
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = longFunction.apply(DenseLongMatrix3D.this.elements[n + n4 * DenseLongMatrix3D.this.sliceStride]);
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseLongMatrix3D.this.rows; ++j) {
                                for (int k = n2; k < DenseLongMatrix3D.this.columns; ++k) {
                                    l = longLongFunction.apply(l, longFunction.apply(DenseLongMatrix3D.this.elements[n + i * DenseLongMatrix3D.this.sliceStride + j * DenseLongMatrix3D.this.rowStride + k * DenseLongMatrix3D.this.columnStride]));
                                }
                                n2 = 0;
                            }
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            l = longFunction.apply(this.elements[n]);
            int n6 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n6; k < this.columns; ++k) {
                        l = longLongFunction.apply(l, longFunction.apply(this.elements[n + i * this.sliceStride + j * this.rowStride + k * this.columnStride]));
                    }
                    n6 = 0;
                }
            }
        }
        return l;
    }

    public long aggregate(final LongLongFunction longLongFunction, final LongFunction longFunction, final LongProcedure longProcedure) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        long l = 0L;
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = DenseLongMatrix3D.this.elements[n + n4 * DenseLongMatrix3D.this.sliceStride];
                        long l2 = 0L;
                        if (longProcedure.apply(l)) {
                            l2 = longLongFunction.apply(l2, longFunction.apply(l));
                        }
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseLongMatrix3D.this.rows; ++j) {
                                for (int k = n2; k < DenseLongMatrix3D.this.columns; ++k) {
                                    l = DenseLongMatrix3D.this.elements[n + i * DenseLongMatrix3D.this.sliceStride + j * DenseLongMatrix3D.this.rowStride + k * DenseLongMatrix3D.this.columnStride];
                                    if (longProcedure.apply(l)) {
                                        l2 = longLongFunction.apply(l2, longFunction.apply(l));
                                    }
                                    n2 = 0;
                                }
                            }
                        }
                        return l2;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            long l2 = this.elements[n];
            if (longProcedure.apply(l2)) {
                l = longLongFunction.apply(l, longFunction.apply(l2));
            }
            int n6 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n6; k < this.columns; ++k) {
                        l2 = this.elements[n + i * this.sliceStride + j * this.rowStride + k * this.columnStride];
                        if (longProcedure.apply(l2)) {
                            l = longLongFunction.apply(l, longFunction.apply(l2));
                        }
                        n6 = 0;
                    }
                }
            }
        }
        return l;
    }

    public long aggregate(final LongLongFunction longLongFunction, final LongFunction longFunction, IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        if (intArrayList.size() == 0 || intArrayList2.size() == 0 || intArrayList3.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final int[] nArray3 = intArrayList3.elements();
        final int n2 = (int)this.index(0, 0, 0);
        long l = 0L;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n3 = Math.min(n3, n);
            Future[] futureArray = new Future[n3];
            int n4 = n / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? n : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = longFunction.apply(DenseLongMatrix3D.this.elements[n2 + nArray[n5] * DenseLongMatrix3D.this.sliceStride + nArray2[n5] * DenseLongMatrix3D.this.rowStride + nArray3[n5] * DenseLongMatrix3D.this.columnStride]);
                        for (int i = n5 + 1; i < n6; ++i) {
                            long l2 = DenseLongMatrix3D.this.elements[n2 + nArray[i] * DenseLongMatrix3D.this.sliceStride + nArray2[i] * DenseLongMatrix3D.this.rowStride + nArray3[i] * DenseLongMatrix3D.this.columnStride];
                            l = longLongFunction.apply(l, longFunction.apply(l2));
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            l = longFunction.apply(this.elements[n2 + nArray[0] * this.sliceStride + nArray2[0] * this.rowStride + nArray3[0] * this.columnStride]);
            for (int i = 1; i < n; ++i) {
                long l2 = this.elements[n2 + nArray[i] * this.sliceStride + nArray2[i] * this.rowStride + nArray3[i] * this.columnStride];
                l = longLongFunction.apply(l, longFunction.apply(l2));
            }
        }
        return l;
    }

    public long aggregate(LongMatrix3D longMatrix3D, final LongLongFunction longLongFunction, final LongLongFunction longLongFunction2) {
        if (!(longMatrix3D instanceof DenseLongMatrix3D)) {
            return super.aggregate(longMatrix3D, longLongFunction, longLongFunction2);
        }
        this.checkShape(longMatrix3D);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        long l = 0L;
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)longMatrix3D.index(0, 0, 0);
        final int n3 = longMatrix3D.sliceStride();
        final int n4 = longMatrix3D.rowStride();
        final int n5 = longMatrix3D.columnStride();
        final long[] lArray = (long[])longMatrix3D.elements();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n6 = Math.min(n6, this.slices);
            Future[] futureArray = new Future[n6];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        int n6 = n + n8 * DenseLongMatrix3D.this.sliceStride;
                        int n22 = n2 + n8 * n3;
                        long l = longLongFunction2.apply(DenseLongMatrix3D.this.elements[n6], lArray[n22]);
                        int n32 = 1;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseLongMatrix3D.this.rows; ++j) {
                                for (int k = n32; k < DenseLongMatrix3D.this.columns; ++k) {
                                    n6 = n + i * DenseLongMatrix3D.this.sliceStride + j * DenseLongMatrix3D.this.rowStride + k * DenseLongMatrix3D.this.columnStride;
                                    n22 = n2 + i * n3 + j * n4 + k * n5;
                                    l = longLongFunction.apply(l, longLongFunction2.apply(DenseLongMatrix3D.this.elements[n6], lArray[n22]));
                                }
                                n32 = 0;
                            }
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            l = longLongFunction2.apply(this.getQuick(0, 0, 0), longMatrix3D.getQuick(0, 0, 0));
            int n10 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n10; k < this.columns; ++k) {
                        int n11 = n + i * this.sliceStride + j * this.rowStride + k * this.columnStride;
                        int n12 = n2 + i * n3 + j * n4 + k * n5;
                        l = longLongFunction.apply(l, longLongFunction2.apply(this.elements[n11], lArray[n12]));
                    }
                    n10 = 0;
                }
            }
        }
        return l;
    }

    public LongMatrix3D assign(final LongFunction longFunction) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseLongMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseLongMatrix3D.this.sliceStride + j * DenseLongMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseLongMatrix3D.this.columns; ++k) {
                                    DenseLongMatrix3D.this.elements[n2] = longFunction.apply(DenseLongMatrix3D.this.elements[n2]);
                                    n2 += DenseLongMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n6] = longFunction.apply(this.elements[n6]);
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public LongMatrix3D assign(final long l) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseLongMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseLongMatrix3D.this.sliceStride + j * DenseLongMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseLongMatrix3D.this.columns; ++k) {
                                    DenseLongMatrix3D.this.elements[n2] = l;
                                    n2 += DenseLongMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n6] = l;
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public LongMatrix3D assign(final long[] lArray) {
        if ((long)lArray.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + lArray.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(lArray, 0, this.elements, 0, lArray.length);
        } else {
            final int n2 = (int)this.index(0, 0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                n = Math.min(n, this.slices);
                Future[] futureArray = new Future[n];
                int n3 = this.slices / n;
                for (int i = 0; i < n; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n - 1 ? this.slices : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n4 * DenseLongMatrix3D.this.rows * DenseLongMatrix3D.this.columns;
                            for (int i = n4; i < n5; ++i) {
                                for (int j = 0; j < DenseLongMatrix3D.this.rows; ++j) {
                                    int n22 = n2 + i * DenseLongMatrix3D.this.sliceStride + j * DenseLongMatrix3D.this.rowStride;
                                    for (int k = 0; k < DenseLongMatrix3D.this.columns; ++k) {
                                        DenseLongMatrix3D.this.elements[n22] = lArray[n++];
                                        n22 += DenseLongMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6 = 0;
                for (int i = 0; i < this.slices; ++i) {
                    for (int j = 0; j < this.rows; ++j) {
                        int n7 = n2 + i * this.sliceStride + j * this.rowStride;
                        for (int k = 0; k < this.columns; ++k) {
                            this.elements[n7] = lArray[n6++];
                            n7 += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    public LongMatrix3D assign(final int[] nArray) {
        if ((long)nArray.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + nArray.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n3 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4 * DenseLongMatrix3D.this.rows * DenseLongMatrix3D.this.columns;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseLongMatrix3D.this.rows; ++j) {
                                int n22 = n2 + i * DenseLongMatrix3D.this.sliceStride + j * DenseLongMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseLongMatrix3D.this.columns; ++k) {
                                    DenseLongMatrix3D.this.elements[n22] = nArray[n++];
                                    n22 += DenseLongMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = 0;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n7 = n2 + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n7] = nArray[n6++];
                        n7 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public LongMatrix3D assign(final long[][][] lArray) {
        if (lArray.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + lArray.length + "slices()=" + this.slices());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                n = Math.min(n, this.slices);
                Future[] futureArray = new Future[n];
                int n2 = this.slices / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.slices : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n3 * DenseLongMatrix3D.this.sliceStride;
                            for (int i = n3; i < n4; ++i) {
                                long[][] lArray3 = lArray[i];
                                if (lArray3.length != DenseLongMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + lArray3.length + "rows()=" + DenseLongMatrix3D.this.rows());
                                }
                                for (int j = 0; j < DenseLongMatrix3D.this.rows; ++j) {
                                    long[] lArray2 = lArray3[j];
                                    if (lArray2.length != DenseLongMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + lArray2.length + "columns()=" + DenseLongMatrix3D.this.columns());
                                    }
                                    System.arraycopy(lArray2, 0, DenseLongMatrix3D.this.elements, n, DenseLongMatrix3D.this.columns);
                                    n += DenseLongMatrix3D.this.columns;
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n5 = 0;
                for (int i = 0; i < this.slices; ++i) {
                    long[][] lArray2 = lArray[i];
                    if (lArray2.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + lArray2.length + "rows()=" + this.rows());
                    }
                    for (int j = 0; j < this.rows; ++j) {
                        long[] lArray3 = lArray2[j];
                        if (lArray3.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + lArray3.length + "columns()=" + this.columns());
                        }
                        System.arraycopy(lArray3, 0, this.elements, n5, this.columns);
                        n5 += this.columns;
                    }
                }
            }
        } else {
            final int n6 = (int)this.index(0, 0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                n = Math.min(n, this.slices);
                Future[] futureArray = new Future[n];
                int n7 = this.slices / n;
                for (int i = 0; i < n; ++i) {
                    final int n8 = i * n7;
                    final int n9 = i == n - 1 ? this.slices : n8 + n7;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n8; i < n9; ++i) {
                                long[][] lArray3 = lArray[i];
                                if (lArray3.length != DenseLongMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + lArray3.length + "rows()=" + DenseLongMatrix3D.this.rows());
                                }
                                for (int j = 0; j < DenseLongMatrix3D.this.rows; ++j) {
                                    int n = n6 + i * DenseLongMatrix3D.this.sliceStride + j * DenseLongMatrix3D.this.rowStride;
                                    long[] lArray2 = lArray3[j];
                                    if (lArray2.length != DenseLongMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + lArray2.length + "columns()=" + DenseLongMatrix3D.this.columns());
                                    }
                                    for (int k = 0; k < DenseLongMatrix3D.this.columns; ++k) {
                                        DenseLongMatrix3D.this.elements[n] = lArray2[k];
                                        n += DenseLongMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < this.slices; ++i) {
                    long[][] lArray4 = lArray[i];
                    if (lArray4.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + lArray4.length + "rows()=" + this.rows());
                    }
                    for (int j = 0; j < this.rows; ++j) {
                        int n10 = n6 + i * this.sliceStride + j * this.rowStride;
                        long[] lArray5 = lArray4[j];
                        if (lArray5.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + lArray5.length + "columns()=" + this.columns());
                        }
                        for (int k = 0; k < this.columns; ++k) {
                            this.elements[n10] = lArray5[k];
                            n10 += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    public LongMatrix3D assign(final LongProcedure longProcedure, final LongFunction longFunction) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseLongMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseLongMatrix3D.this.sliceStride + j * DenseLongMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseLongMatrix3D.this.columns; ++k) {
                                    long l = DenseLongMatrix3D.this.elements[n2];
                                    if (longProcedure.apply(l)) {
                                        DenseLongMatrix3D.this.elements[n2] = longFunction.apply(l);
                                    }
                                    n2 += DenseLongMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        long l = this.elements[n6];
                        if (longProcedure.apply(l)) {
                            this.elements[n6] = longFunction.apply(l);
                        }
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public LongMatrix3D assign(final LongProcedure longProcedure, final long l) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseLongMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseLongMatrix3D.this.sliceStride + j * DenseLongMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseLongMatrix3D.this.columns; ++k) {
                                    long l2 = DenseLongMatrix3D.this.elements[n2];
                                    if (longProcedure.apply(l2)) {
                                        DenseLongMatrix3D.this.elements[n2] = l;
                                    }
                                    n2 += DenseLongMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        long l2 = this.elements[n6];
                        if (longProcedure.apply(l2)) {
                            this.elements[n6] = l;
                        }
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public LongMatrix3D assign(LongMatrix3D longMatrix3D) {
        LongMatrix3D longMatrix3D2;
        if (!(longMatrix3D instanceof DenseLongMatrix3D)) {
            super.assign(longMatrix3D);
            return this;
        }
        DenseLongMatrix3D denseLongMatrix3D = (DenseLongMatrix3D)longMatrix3D;
        if (denseLongMatrix3D == this) {
            return this;
        }
        this.checkShape(denseLongMatrix3D);
        if (this.haveSharedCells(denseLongMatrix3D)) {
            longMatrix3D2 = denseLongMatrix3D.copy();
            if (!(longMatrix3D2 instanceof DenseLongMatrix3D)) {
                super.assign(longMatrix3D);
                return this;
            }
            denseLongMatrix3D = longMatrix3D2;
        }
        longMatrix3D2 = denseLongMatrix3D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseLongMatrix3D.isNoView) {
            System.arraycopy(((DenseLongMatrix3D)longMatrix3D2).elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        final int n2 = (int)this.index(0, 0, 0);
        final int n3 = (int)((DenseLongMatrix3D)longMatrix3D2).index(0, 0, 0);
        final int n4 = ((DenseLongMatrix3D)longMatrix3D2).sliceStride;
        final int n5 = ((DenseLongMatrix3D)longMatrix3D2).rowStride;
        final int n6 = ((DenseLongMatrix3D)longMatrix3D2).columnStride;
        final long[] lArray = ((DenseLongMatrix3D)longMatrix3D2).elements;
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n7 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseLongMatrix3D.this.rows; ++j) {
                                int n = n2 + i * DenseLongMatrix3D.this.sliceStride + j * DenseLongMatrix3D.this.rowStride;
                                int n22 = n3 + i * n4 + j * n5;
                                for (int k = 0; k < DenseLongMatrix3D.this.columns; ++k) {
                                    DenseLongMatrix3D.this.elements[n] = lArray[n22];
                                    n += DenseLongMatrix3D.this.columnStride;
                                    n22 += n6;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n10 = n2 + i * this.sliceStride + j * this.rowStride;
                    int n11 = n3 + i * n4 + j * n5;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n10] = lArray[n11];
                        n10 += this.columnStride;
                        n11 += n6;
                    }
                }
            }
        }
        return this;
    }

    public LongMatrix3D assign(LongMatrix3D longMatrix3D, final LongLongFunction longLongFunction) {
        if (!(longMatrix3D instanceof DenseLongMatrix3D)) {
            super.assign(longMatrix3D, longLongFunction);
            return this;
        }
        this.checkShape(longMatrix3D);
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)longMatrix3D.index(0, 0, 0);
        final int n3 = longMatrix3D.sliceStride();
        final int n4 = longMatrix3D.rowStride();
        final int n5 = longMatrix3D.columnStride();
        final long[] lArray = (long[])longMatrix3D.elements();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n6 = Math.min(n6, this.slices);
            Future[] futureArray = new Future[n6];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseLongMatrix3D.this.rows; ++j) {
                                int n6 = n + i * DenseLongMatrix3D.this.sliceStride + j * DenseLongMatrix3D.this.rowStride;
                                int n22 = n2 + i * n3 + j * n4;
                                for (int k = 0; k < DenseLongMatrix3D.this.columns; ++k) {
                                    DenseLongMatrix3D.this.elements[n6] = longLongFunction.apply(DenseLongMatrix3D.this.elements[n6], lArray[n22]);
                                    n6 += DenseLongMatrix3D.this.columnStride;
                                    n22 += n5;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n10 = n + i * this.sliceStride + j * this.rowStride;
                    int n11 = n2 + i * n3 + j * n4;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n10] = longLongFunction.apply(this.elements[n10], lArray[n11]);
                        n10 += this.columnStride;
                        n11 += n5;
                    }
                }
            }
        }
        return this;
    }

    public LongMatrix3D assign(LongMatrix3D longMatrix3D, final LongLongFunction longLongFunction, IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        if (!(longMatrix3D instanceof DenseLongMatrix3D)) {
            super.assign(longMatrix3D, longLongFunction);
            return this;
        }
        this.checkShape(longMatrix3D);
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)longMatrix3D.index(0, 0, 0);
        final int n3 = longMatrix3D.sliceStride();
        final int n4 = longMatrix3D.rowStride();
        final int n5 = longMatrix3D.columnStride();
        final long[] lArray = (long[])longMatrix3D.elements();
        int n6 = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final int[] nArray3 = intArrayList3.elements();
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (n7 > 1 && n6 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n7 = Math.min(n7, n6);
            Future[] futureArray = new Future[n7];
            int n8 = n6 / n7;
            for (int i = 0; i < n7; ++i) {
                final int n9 = i * n8;
                final int n10 = i == n7 - 1 ? n6 : n9 + n8;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n9; i < n10; ++i) {
                            int n6 = n + nArray[i] * DenseLongMatrix3D.this.sliceStride + nArray2[i] * DenseLongMatrix3D.this.rowStride + nArray3[i] * DenseLongMatrix3D.this.columnStride;
                            int n22 = n2 + nArray[i] * n3 + nArray2[i] * n4 + nArray3[i] * n5;
                            DenseLongMatrix3D.this.elements[n6] = longLongFunction.apply(DenseLongMatrix3D.this.elements[n6], lArray[n22]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n6; ++i) {
                int n11 = n + nArray[i] * this.sliceStride + nArray2[i] * this.rowStride + nArray3[i] * this.columnStride;
                int n12 = n2 + nArray[i] * n3 + nArray2[i] * n4 + nArray3[i] * n5;
                this.elements[n11] = longLongFunction.apply(this.elements[n11], lArray[n12]);
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        final int n2 = (int)this.index(0, 0, 0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n4;
            n3 = Math.min(n3, this.slices);
            Future[] futureArray = new Future[n3];
            Integer[] integerArray = new Integer[n3];
            int n5 = this.slices / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? this.slices : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < DenseLongMatrix3D.this.rows; ++j) {
                                int n22 = n2 + i * DenseLongMatrix3D.this.sliceStride + j * DenseLongMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseLongMatrix3D.this.columns; ++k) {
                                    if (DenseLongMatrix3D.this.elements[n22] != 0L) {
                                        ++n;
                                    }
                                    n22 += DenseLongMatrix3D.this.columnStride;
                                }
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n = integerArray[0];
                for (n4 = 1; n4 < n3; ++n4) {
                    n += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n8 = n2 + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        if (this.elements[n8] != 0L) {
                            ++n;
                        }
                        n8 += this.columnStride;
                    }
                }
            }
        }
        return n;
    }

    public long[] elements() {
        return this.elements;
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, LongArrayList longArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        longArrayList.clear();
        int n = (int)this.index(0, 0, 0);
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int n2 = n + i * this.sliceStride + j * this.rowStride;
                for (int k = 0; k < this.columns; ++k) {
                    long l = this.elements[n2];
                    if (l < 0L) {
                        intArrayList.add(i);
                        intArrayList2.add(j);
                        intArrayList3.add(k);
                        longArrayList.add(l);
                    }
                    n2 += this.columnStride;
                }
            }
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, LongArrayList longArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        longArrayList.clear();
        int n = (int)this.index(0, 0, 0);
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int n2 = n + i * this.sliceStride + j * this.rowStride;
                for (int k = 0; k < this.columns; ++k) {
                    long l = this.elements[n2];
                    if (l != 0L) {
                        intArrayList.add(i);
                        intArrayList2.add(j);
                        intArrayList3.add(k);
                        longArrayList.add(l);
                    }
                    n2 += this.columnStride;
                }
            }
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, LongArrayList longArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        longArrayList.clear();
        int n = (int)this.index(0, 0, 0);
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int n2 = n + i * this.sliceStride + j * this.rowStride;
                for (int k = 0; k < this.columns; ++k) {
                    long l = this.elements[n2];
                    if (l > 0L) {
                        intArrayList.add(i);
                        intArrayList2.add(j);
                        intArrayList3.add(k);
                        longArrayList.add(l);
                    }
                    n2 += this.columnStride;
                }
            }
        }
    }

    public long getQuick(int n, int n2, int n3) {
        return this.elements[this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride];
    }

    public long index(int n, int n2, int n3) {
        return this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
    }

    public LongMatrix3D like(int n, int n2, int n3) {
        return new DenseLongMatrix3D(n, n2, n3);
    }

    public LongMatrix2D like2D(int n, int n2) {
        return new DenseLongMatrix2D(n, n2);
    }

    public long[] getMaxLocation() {
        final int n = (int)this.index(0, 0, 0);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        long l = 0L;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n6;
            n5 = Math.min(n5, this.slices);
            Future[] futureArray = new Future[n5];
            long[][] lArray = new long[n5][2];
            int n7 = this.slices / n5;
            for (n6 = 0; n6 < n5; ++n6) {
                final int n8 = n6 * n7;
                final int n9 = n6 == n5 - 1 ? this.slices : n8 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int n5 = n8;
                        int n2 = 0;
                        int n3 = 0;
                        long l = DenseLongMatrix3D.this.elements[n + n8 * DenseLongMatrix3D.this.sliceStride];
                        int n4 = 1;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseLongMatrix3D.this.rows; ++j) {
                                for (int k = n4; k < DenseLongMatrix3D.this.columns; ++k) {
                                    long l2 = DenseLongMatrix3D.this.elements[n + i * DenseLongMatrix3D.this.sliceStride + j * DenseLongMatrix3D.this.rowStride + k * DenseLongMatrix3D.this.columnStride];
                                    if (l >= l2) continue;
                                    l = l2;
                                    n5 = i;
                                    n2 = j;
                                    n3 = k;
                                }
                                n4 = 0;
                            }
                        }
                        return new long[]{l, n5, n2, n3};
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    lArray[n6] = (long[])futureArray[n6].get();
                }
                l = lArray[0][0];
                n2 = (int)lArray[0][1];
                n3 = (int)lArray[0][2];
                n4 = (int)lArray[0][3];
                for (n6 = 1; n6 < n5; ++n6) {
                    if (l >= lArray[n6][0]) continue;
                    l = lArray[n6][0];
                    n2 = (int)lArray[n6][1];
                    n3 = (int)lArray[n6][2];
                    n4 = (int)lArray[n6][3];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            l = this.elements[n];
            int n10 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n10; k < this.columns; ++k) {
                        long l2 = this.elements[n + i * this.sliceStride + j * this.rowStride + k * this.columnStride];
                        if (l >= l2) continue;
                        l = l2;
                        n2 = i;
                        n3 = j;
                        n4 = k;
                    }
                    n10 = 0;
                }
            }
        }
        return new long[]{l, n2, n3, n4};
    }

    public long[] getMinLocation() {
        final int n = (int)this.index(0, 0, 0);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        long l = 0L;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n6;
            n5 = Math.min(n5, this.slices);
            Future[] futureArray = new Future[n5];
            long[][] lArray = new long[n5][2];
            int n7 = this.slices / n5;
            for (n6 = 0; n6 < n5; ++n6) {
                final int n8 = n6 * n7;
                final int n9 = n6 == n5 - 1 ? this.slices : n8 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int n5 = n8;
                        int n2 = 0;
                        int n3 = 0;
                        long l = DenseLongMatrix3D.this.elements[n + n5 * DenseLongMatrix3D.this.sliceStride];
                        int n4 = 1;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseLongMatrix3D.this.rows; ++j) {
                                for (int k = n4; k < DenseLongMatrix3D.this.columns; ++k) {
                                    long l2 = DenseLongMatrix3D.this.elements[n + i * DenseLongMatrix3D.this.sliceStride + j * DenseLongMatrix3D.this.rowStride + k * DenseLongMatrix3D.this.columnStride];
                                    if (l <= l2) continue;
                                    l = l2;
                                    n5 = i;
                                    n2 = j;
                                    n3 = k;
                                }
                                n4 = 0;
                            }
                        }
                        return new long[]{l, n5, n2, n3};
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    lArray[n6] = (long[])futureArray[n6].get();
                }
                l = lArray[0][0];
                n2 = (int)lArray[0][1];
                n3 = (int)lArray[0][2];
                n4 = (int)lArray[0][3];
                for (n6 = 1; n6 < n5; ++n6) {
                    if (l <= lArray[n6][0]) continue;
                    l = lArray[n6][0];
                    n2 = (int)lArray[n6][1];
                    n3 = (int)lArray[n6][2];
                    n4 = (int)lArray[n6][3];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            l = this.elements[n];
            int n10 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n10; k < this.columns; ++k) {
                        long l2 = this.elements[n + i * this.sliceStride + j * this.rowStride + k * this.columnStride];
                        if (l <= l2) continue;
                        l = l2;
                        n2 = i;
                        n3 = j;
                        n4 = k;
                    }
                    n10 = 0;
                }
            }
        }
        return new long[]{l, n2, n3, n4};
    }

    public void setQuick(int n, int n2, int n3, long l) {
        this.elements[this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride] = l;
    }

    public long[][][] toArray() {
        final long[][][] lArray = new long[this.slices][this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n3 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            long[][] lArray3 = lArray[i];
                            for (int j = 0; j < DenseLongMatrix3D.this.rows; ++j) {
                                int n = n2 + i * DenseLongMatrix3D.this.sliceStride + j * DenseLongMatrix3D.this.rowStride;
                                long[] lArray2 = lArray3[j];
                                for (int k = 0; k < DenseLongMatrix3D.this.columns; ++k) {
                                    lArray2[k] = DenseLongMatrix3D.this.elements[n];
                                    n += DenseLongMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                long[][] lArray2 = lArray[i];
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n2 + i * this.sliceStride + j * this.rowStride;
                    long[] lArray3 = lArray2[j];
                    for (int k = 0; k < this.columns; ++k) {
                        lArray3[k] = this.elements[n6];
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return lArray;
    }

    public LongMatrix1D vectorize() {
        DenseLongMatrix1D denseLongMatrix1D = new DenseLongMatrix1D((int)this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            denseLongMatrix1D.viewPart(i * n, n).assign(this.viewSlice(i).vectorize());
        }
        return denseLongMatrix1D;
    }

    public long zSum() {
        long l = 0L;
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n3;
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n4 = this.slices / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.slices : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = 0L;
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < DenseLongMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseLongMatrix3D.this.sliceStride + j * DenseLongMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseLongMatrix3D.this.columns; ++k) {
                                    l += DenseLongMatrix3D.this.elements[n2];
                                    n2 += DenseLongMatrix3D.this.columnStride;
                                }
                            }
                        }
                        return l;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    l += ((Long)futureArray[n3].get()).longValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n7 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        l += this.elements[n7];
                        n7 += this.columnStride;
                    }
                }
            }
        }
        return l;
    }

    protected boolean haveSharedCellsRaw(LongMatrix3D longMatrix3D) {
        if (longMatrix3D instanceof SelectedDenseLongMatrix3D) {
            SelectedDenseLongMatrix3D selectedDenseLongMatrix3D = (SelectedDenseLongMatrix3D)longMatrix3D;
            return this.elements == selectedDenseLongMatrix3D.elements;
        }
        if (longMatrix3D instanceof DenseLongMatrix3D) {
            DenseLongMatrix3D denseLongMatrix3D = (DenseLongMatrix3D)longMatrix3D;
            return this.elements == denseLongMatrix3D.elements;
        }
        return false;
    }

    protected LongMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        return new DenseLongMatrix2D(n, n2, this.elements, n3, n4, n5, n6, true);
    }

    protected LongMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedDenseLongMatrix3D(this.elements, nArray, nArray2, nArray3, 0);
    }
}

