#' Obtaining indexes associated with the solution sources.
#'@description Function to estimate the total n of the S.S. (n), E.S., ks, c, ds, n.I.I.,
#'Sum.n.I.I., and percentage of I.I. (P.I.I.) by each S.S..
#'@usage SolutionSource(SolutionData,Production,EffectivenessOfSolution,Id,Verbose=TRUE)
#@param DataLoss It is an matrix object containing data from loss sources.
#'@param SolutionData It is an matrix object containing data from Solution sources.
#'@param Production Matrix with a column containing the production data.
#'@param EffectivenessOfSolution Output generated by the function  `EffectivenessOfSolution`
#'@param Id Logical vector indicating the lines of the `EffectivenessOfSolution` that are relevant.
#'Output generated by the function SelectEffectivenessOfSolution

#'@param Verbose Logical value (TRUE/FALSE). TRUE displays the results of the analysis.
#'@author Germano Leao Demolin-Leite (Instituto de Ciencias Agrarias da UFMG) \cr
#' Alcinei Mistico Azevedo (Instituto de Ciencias Agrarias da UFMG)

#'@return The function returns indices associated with the source of loss.
#'@importFrom stats lm
#'@export
#'@examples
#\dontrun{
#'library(ImportanceIndice)
#'data("DataLossSource")
#'data("DataSolutionSource")
#'data("DataProduction")
#'data("DataNumberSamples")
#'
#'Distribution_LossSource(DataLossSource)
#'Distribution_SolutionSource(DataSolutionSource)
#'
#'#################################################
#'###################################################
#'
#'
#'
#'LS=LossSource(DataLoss = DataLossSource,DataProd = DataProduction,verbose = TRUE)
#'LS
#'
#'LP=LossProduction(Data=DataLossSource,Prod = DataProduction,
#'                  Evaluation=DataNumberSamples,
#'                  SegurityMargen=0.75,MaximumToleranceOfLossFruits=1)
#'LP
#'
#'
#'ES=EffectivenessOfSolution(DataLossSource=DataLossSource,
#'                           DataSolutionSource=DataSolutionSource,Production =DataProduction)
#'ES
#'
#'
#'
#'
#'id=SelectEffectivenessOfSolution(ES)
#'id=c(TRUE , TRUE,  TRUE , FALSE,  TRUE)
#'
#'
#'SS=SolutionSource(SolutionData = DataSolutionSource,
#'                  EffectivenessOfSolution = ES,Production = DataProduction,Id = id)
#'SS
#'
#'
#'NAL=NonAttentionLevel(EffectivenessOfSolution = ES,LossProduction = LP,Id = id,Verbose=TRUE)
#'NAL
#}





  SolutionSource=function(SolutionData,Production,
                          EffectivenessOfSolution,Id,Verbose=TRUE){

D2=SolutionData
Prod=Production
Es=EffectivenessOfSolution







  Esb=Es[Id,]


  n=colSums(D2)
  N=n[order(names(n))]

  c=colSums(D2>0)
  C=c[order(names(c))]

  x2=apply(D2,2, function(x) 1-suppressWarnings(chisq.test(x)$p.value))
  X2=x2[order(names(x2))]


  xx=cbind(colnames(D2),"",0)
  colnames(xx)=colnames(Esb)
  Esb=rbind(Esb,xx)

  E.S.=tapply(as.numeric(Esb[,3]),Esb[,1],sum)
  K.S.=E.S./N
  ds=X2

  n.I.I=K.S.*C*ds

  S.n.I.I=sum(n.I.I)

  P.I.I=100*n.I.I/S.n.I.I



 Res1=cbind(n=N,E.S.=E.S.,K.S.=K.S.,c=C,ds=ds,n.I.I=n.I.I,S.n.I.I=S.n.I.I,P.I.I=P.I.I)




   D=D2
   chisqq=apply(D,2, function(x) suppressWarnings(chisq.test(x)$p.value))

   Var=round(apply(D,2,var),4)
 Mean=round(apply(D,2,mean),4)
 p.Value=round(chisqq,4)


 Class.=NULL
 for(i in 1:length(p.Value)){
   p.V=p.Value[i]
   pv2=100*(p.V)
   class="Random"
   if(pv2<2.5){
     class="Aggregated"
   }

   if(pv2>97.5){
     class="Regular"
   }

   Class.=c(Class.,class)
 }



 Res2=data.frame(Var=Var,Mean=Mean,p.Value=p.Value,Aggregation=Class.)
 return(list(Res1=round(Res1,6),Res2=Res2))
}

