% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swp.R
\name{SWP}
\alias{SWP}
\title{Sweep Function}
\usage{
SWP(V, b)
}
\arguments{
\item{V}{A symmetric matrix to be swept; this matrix cannot contain missing
data or infinite values.}

\item{b}{An array of integers or column names to sweep.}
}
\value{
The swept matrix \code{V}.  Sweeping will not occur if the column
  being swept has a zero-valued diagonal element.
}
\description{
\code{SWP} performs the sweep operator.
}
\details{
This program applies the sweep operator as defined in (Dempster 1969).
}
\examples{
set.seed(100)
# generate a symmetric positive definite matrix
Sigma <- rWishart(1,4,diag(3))[,,1]
# sweep all the columns to produce the inverse
Sigma.inv <- SWP(Sigma,1:3)
}
\references{
Dempster, A.P. (1969). \emph{Elements of continuous multivariate analysis}. Reading, MA: Addison-Wesley.
}

