#include "ghquads.h"
#include <iostream>
#include <stdexcept>

namespace irtpp{

        const double full_gh_quads[] = {
                -1,1,-2.33441421833898,-0.741963784302726,0.741963784302726,2.33441421833898,-3.32425743355212,-1.88917587775371,-0.616706590192594,0.616706590192594,1.88917587775371,3.32425743355212,-4.14454718612589,-2.80248586128754,-1.63651904243511,-0.539079811351375,0.539079811351375,1.63651904243511,2.80248586128754,4.14454718612589,-4.85946282833231,-3.58182348355193,-2.48432584163895,-1.46598909439116,-0.484935707515498,0.484935707515498,1.46598909439116,2.48432584163896,3.58182348355193,4.85946282833231,-5.50090170446775,-4.27182584793228,-3.2237098287701,-2.2594644510008,-1.34037519715162,-0.444403001944139,0.444403001944139,1.34037519715162,2.2594644510008,3.2237098287701,4.27182584793228,5.50090170446775,-6.08740954690129,-4.89693639734556,-3.88692457505977,-2.96303657983867,-2.08834474570194,-1.24268895548546,-0.412590457954602,0.412590457954602,1.24268895548546,2.08834474570194,2.96303657983867,3.88692457505977,4.89693639734556,6.08740954690129,-6.63087819839313,-5.47222570594935,-4.49295530252001,-3.60087362417155,-2.7602450476307,-1.95198034571633,-1.16382910055496,-0.386760604500557,0.386760604500557,1.16382910055497,1.95198034571633,2.7602450476307,3.60087362417155,4.49295530252001,5.47222570594934,6.63087819839313,-7.13946484914648,-6.0077459113596,-5.05407268544274,-4.1880202316294,-3.37473653577809,-2.59583368891124,-1.83977992150865,-1.0983955180915,-0.365245755507698,0.365245755507698,1.0983955180915,1.83977992150865,2.59583368891124,3.37473653577809,4.1880202316294,5.05407268544274,6.0077459113596,7.13946484914648,-7.61904854167976,-6.51059015701366,-5.5787388058932,-4.73458133404606,-3.94396735065732,-3.18901481655339,-2.45866361117237,-1.74524732081413,-1.04294534880275,-0.346964157081356,0.346964157081356,1.04294534880275,1.74524732081413,2.45866361117237,3.18901481655339,3.94396735065732,4.73458133404606,5.5787388058932,6.51059015701365,7.61904854167976,-8.07402998402172,-6.98598042401882,-6.0730749511229,-5.24772443371443,-4.47636197731087,-3.74149635026652,-3.03240422783168,-2.34175999628771,-1.66412483911791,-0.995162422271215,-0.331179315715274,0.331179315715274,0.995162422271216,1.66412483911791,2.34175999628771,3.03240422783167,3.74149635026652,4.47636197731087,5.24772443371442,6.0730749511229,6.98598042401882,8.07402998402172,-8.50780351919525,-7.43789066602166,-6.54167500509863,-5.7327471752512,-4.97804137463912,-4.2603836050199,-3.56930676407356,-2.89772864322332,-2.24046785169175,-1.59348042981642,-0.953421922932109,-0.317370096629452,0.317370096629452,0.953421922932109,1.59348042981642,2.24046785169175,2.89772864322331,3.56930676407356,4.2603836050199,4.97804137463912,5.7327471752512,6.54167500509864,7.43789066602166,8.50780351919525,-8.92305172782825,-7.86942669763774,-6.98808877062341,-6.19369348379631,-5.45361538385783,-4.75094748308538,-4.07542721441223,-3.42015637399998,-2.78013849950975,-2.15153009012165,-1.5312157086954,-0.916545041338628,-0.305155970759298,0.305155970759298,0.916545041338628,1.5312157086954,2.15153009012165,2.78013849950975,3.42015637399998,4.07542721441222,4.75094748308538,5.45361538385783,6.19369348379631,6.98808877062341,7.86942669763774,8.92305172782825,-9.32193781440878,-8.28306954086142,-7.41512528617607,-6.63373149395043,-5.90665632582499,-5.21722367344745,-4.55534038459698,-3.91425372596363,-3.28910697017183,-2.67620187952694,-2.07258267414462,-1.47578173695792,-0.88365256299298,-0.294251714488713,0.294251714488713,0.883652562992981,1.47578173695792,2.07258267414462,2.67620187952694,3.28910697017183,3.91425372596363,4.55534038459697,5.21722367344745,5.90665632582499,6.63373149395043,7.41512528617607,8.28306954086142,9.32193781440877,-9.70623599735953,-8.68083772273222,-7.82505174435281,-7.05539686696029,-6.33999768686959,-5.66238185008287,-5.01260059648652,-4.38402036589805,-3.77189442315924,-3.17263463942041,-2.58340210022927,-2.00185861295643,-1.42600565837411,-0.854073351710973,-0.284438760736209,0.28443876073621,0.854073351710974,1.42600565837411,2.00185861295643,2.58340210022927,3.1726346394204,3.77189442315924,4.38402036589805,5.01260059648652
                ,5.66238185008288,6.3399976868696,7.05539686696029,7.82505174435281,8.68083772273221,9.70623599735953,-10.0774226742295,-9.06439921070241,-8.21972876538224,-7.46075575412152,-6.75593083054071,-6.08896430907699,-5.45003327362343,-4.83260461324449,-4.23202110999541,-3.64478124988083,-3.06813516901312,-2.4998404151874,-1.93800490592572,-1.38098019927214,-0.827284903779766,-0.275546419230276,0.275546419230276,0.827284903779765,1.38098019927214,1.93800490592572,2.4998404151874,3.06813516901312,3.64478124988083,4.23202110999541,4.83260461324449,5.45003327362343,6.08896430907699,6.75593083054071,7.46075575412152,8.21972876538224,9.06439921070241,10.0774226742295,-10.436741871005,-9.4351508337608,-8.60070523398343,-7.85151759069907,-7.15633925913484,-6.49904635392796,-5.86992758859678,-5.26253648173463,-4.67229069140098,-4.09575897195416,-3.53026163407417,-2.97362965030399,-2.42405050975623,-1.87996436642019,-1.33999062552262,-0.802873460783712,-0.267439183951557,0.267439183951557,0.802873460783713,1.33999062552262,1.87996436642019,2.42405050975623,2.97362965030399,3.53026163407417,4.09575897195417,4.67229069140098,5.26253648173463,5.86992758859678,6.49904635392797,7.15633925913484,7.85151759069907,8.60070523398342,9.4351508337608,10.4367418710051,-10.7852533123875,-9.79427601958303,-8.96928653456261,-8.22911536747157,-7.54279303921139,-6.89434764617391,-6.27416832680951,-5.67588471010667,-5.09497851385761,-4.52807699060017,-3.97255734192999,-3.42630859512913,-2.88757969500472,-2.35487771599254,-1.82689657798674,-1.30246495448017,-0.780506492052466,-0.260007925249,0.260007925249,0.780506492052465,1.30246495448017,1.82689657798674,2.35487771599254,2.88757969500472,3.42630859512913,3.97255734192999,4.52807699060018,5.09497851385761,5.67588471010667,6.2741683268095,6.89434764617392,7.54279303921139,8.22911536747157,8.96928653456261,9.79427601958302,10.7852533123875,-11.1238684349499,-10.1427876611297,-9.32658475739557,-8.59476413638611,-7.91661692848036,-7.27631166555513,-6.66432886441472,-6.07436604205956,-5.50196075681102,-4.94379002980226,-4.39727830993271,-3.86036173816326,-3.33133806054401,-2.80876641390191,-2.29139756362421,-1.77812342513656,-1.26793911478075,-0.759913248136739,-0.253163635335934,0.253163635335935,0.759913248136739,1.26793911478075,1.77812342513656,2.29139756362421,2.80876641390192,3.33133806054401,3.86036173816326,4.39727830993271,4.94379002980227,5.50196075681102,6.07436604205956,6.66432886441471,7.27631166555514,7.91661692848035,8.59476413638611,9.32658475739556,10.1427876611297,11.1238684349499,-11.4533778415487,-10.4815605346743,-9.67355636693403,-8.94950454385555,-8.27894062365947,-7.64616376454146,-7.04173840645382,-6.45942337758377,-5.89480567537202,-5.34460544572009,-4.80628719209387,-4.27782615636275,-3.75755977616899,-3.24408873299987,-2.73620834046543,-2.23285921863487,-1.73309059063172,-1.23603200479916,-0.740870725285931,-0.246832896022724,0.246832896022724,0.740870725285931,1.23603200479916,1.73309059063172,2.23285921863487,2.73620834046543,3.24408873299987,3.75755977616899,4.27782615636275,4.80628719209388,5.34460544572009,5.89480567537202,6.45942337758376,7.04173840645383,7.64616376454146,8.27894062365948,8.94950454385555,9.67355636693404,10.4815605346743,11.4533778415487,-11.7744725564588,-10.8113562181889,-10.0110309523132,-9.29423581592503,-8.63073654044265,-8.00495445933188,-7.40753168316143,-6.83228298422121,-6.27483970445827,-5.73195994192493,-5.20114276123495,-4.68039648970331,-4.16809152552581,-3.66286244104599,-3.16354028354901,-2.66910411660381,-2.1786452087625,-1.69133973283491,-1.20642727782793,-0.723193344939171,-0.240954534866591,0.240954534866591,0.72319334493917,1.20642727782793,1.69133973283491,2.1786452087625,2.66910411660381,3.16354028354901,3.66286244104598,4.16809152552581,4.68039648970331,5.20114276123495,5.73195994192493,6.27483970445827,6.8322829842212,7.40753168316143,8.00495445933187,8.63073654044266,9.29423581592504,10.0110309523132,10.8113562181889,11.7744725564588,-12.0877607090584,-11.1328425242439,-10.3397335076433,-9.62974115466647,-8.97284870362887
                ,-8.353592294951,-7.76268638616356,-7.19399723648843,-6.64319639972759,-6.10707581702975,-5.58316482964562,-5.06950023458978,-4.56448030219913,-4.06676779049556,-3.5752229994252,-3.088855994142,-2.60679146298743,-2.12824211918547,-1.6524879894794,-1.17885980332886,-0.706725238106345,-0.235477118171922,0.235477118171923,0.706725238106345,1.17885980332886,1.6524879894794,2.12824211918547,2.60679146298742,3.088855994142,3.5752229994252,4.06676779049556,4.56448030219913,5.06950023458978,5.58316482964562,6.10707581702976,6.6431963997276,7.19399723648843,7.76268638616355,8.353592294951,8.97284870362887,9.62974115466647,10.3397335076433,11.1328425242439,12.0877607090584,-12.3937807920193,-11.4466088526052,-10.6603019342805,-9.95670757249862,-9.30601517311909,-8.69286919323684,-8.10805184505423,-7.54547711606465,-7.00085336253322,-6.47100304552628,-5.95348237823838,-5.44635301621658,-4.94803717675467,-4.45722146003149,-3.97279054623598,-3.49377997631787,-3.01934153337935,-2.54871717116518,-2.0812188638081,-1.61621261955474,-1.15310544466349,-0.69133439086933,-0.230357044068977,0.230357044068977,0.69133439086933,1.15310544466349,1.61621261955474,2.0812188638081,2.54871717116518,3.01934153337935,3.49377997631787,3.97279054623598,4.45722146003149,4.94803717675466,5.44635301621658,5.95348237823838,6.47100304552627,7.00085336253322,7.54547711606465,8.10805184505423,8.69286919323683,9.30601517311908,9.95670757249862,10.6603019342805,11.4466088526052,12.3937807920193,-12.6930123154396,-11.7531784616166,-10.9733009585136,-10.2757415817335,-9.63088568694905,-9.02348028041765,-8.44437132252344,-7.88751731650038,-7.34866056590891,-6.82465132074597,-6.3130699149055,-5.81199998770253,-5.31988462041909,-4.83543088587896,-4.35754410879029,-3.88528111724839,-3.41781604868478,-2.95441468888012,-2.49441474304002,-2.03721030325903,-1.58223931967496,-1.12897323150965,-0.676908142206348,-0.225557072980163,0.225557072980164,0.676908142206348,1.12897323150965,1.58223931967496,2.03721030325903,2.49441474304002,2.95441468888012,3.41781604868478,3.88528111724839,4.35754410879029,4.83543088587896,5.31988462041908,5.81199998770253,6.3130699149055,6.82465132074598,7.34866056590892,7.88751731650037,8.44437132252344,9.02348028041765,9.63088568694905,10.2757415817335,10.9733009585136,11.7531784616166,12.6930123154396,-12.9858844554155,-12.0530183809245,-11.2792333214826,-10.5873817491918,-9.94803570963751,-9.34603959357573,-8.77229957951461,-8.22081590798213,-7.68736240671251,-7.16881483785391,-6.66277539901872,-6.16734738865992,-5.68099229103328,-5.20243499339991,-4.7305985502286,-4.26455784303811,-3.80350574174201,-3.34672777473243,-2.89358272770774,-2.44348745265402,-1.99590470979512,-1.55033321433877,-1.10629928939718,-0.663349679508292,-0.221045181644543,0.221045181644544,0.663349679508292,1.10629928939718,1.55033321433877,1.99590470979512,2.44348745265402,2.89358272770774,3.34672777473243,3.80350574174201,4.26455784303811,4.7305985502286,5.20243499339991,5.68099229103328,6.16734738865992,6.66277539901872,7.16881483785391,7.6873624067125,8.22081590798213,8.77229957951461,9.34603959357573,9.94803570963751,10.5873817491918,11.2792333214826,12.0530183809245,12.9858844554155
        };
        const double full_gh_weights[] = {
                0.5,0.5,0.0458758547680685,0.454124145231932,0.454124145231931,0.0458758547680686,0.00255578440205626,0.0886157460419144,0.408828469556029,0.408828469556029,0.0886157460419144,0.00255578440205624,0.000112614538375368,0.00963522012078823,0.117239907661759,0.373012257679077,0.373012257679077,0.117239907661759,0.00963522012078826,0.000112614538375368,4.31065263071827e-06,0.000758070934312221,0.0191115805007703,0.135483702980268,0.344642334932019,0.344642334932019,0.135483702980268,0.0191115805007703,0.000758070934312219,4.3106526307183e-06,1.49992716763717e-07,4.8371849225906e-05,0.0022033806875332,0.0291166879123642,0.14696704804533,0.32166436151283,0.32166436151283,0.14696704804533,0.0291166879123641,0.0022033806875332,4.83718492259064e-05,1.49992716763717e-07,4.86816125774838e-09,2.66099134406765e-06,0.000200339553760744,0.00442891910694738,0.0386501088242535,0.154083339842514,0.30263462681302,0.30263462681302,0.154083339842514,0.0386501088242535,0.00442891910694742,0.000200339553760745,2.66099134406764e-06,4.86816125774834e-09,1.49781472316185e-10,1.30947321628682e-07,1.53000321624873e-05,0.00052598492657391,0.00726693760118474,0.0472847523540141,0.15833837275095,0.286568521238012,0.286568521238012,0.15833837275095,0.0472847523540141,0.0072669376011847,0.000525984926573909,1.53000321624871e-05,1.30947321628682e-07,1.49781472316184e-10,4.41658876935867e-12,5.90548847883654e-09,1.02155239763698e-06,5.17989614411624e-05,0.00106548479629165,0.0105165177519413,0.0548966324802226,0.160685303893513,0.272783234654288,0.272783234654288,0.160685303893513,0.0548966324802227,0.0105165177519413,0.00106548479629165,5.17989614411622e-05,1.02155239763698e-06,5.90548847883653e-09,4.4165887693586e-12,1.25780067243792e-13,2.48206236231516e-10,6.12749025998291e-08,4.40212109023086e-06,0.000128826279961929,0.00183010313108049,0.013997837447101,0.0615063720639768,0.161739333984,0.260793063449555,0.260793063449555,0.161739333984,0.0615063720639768,0.013997837447101,0.00183010313108049,0.00012882627996193,4.40212109023089e-06,6.12749025998294e-08,2.48206236231518e-10,1.25780067243792e-13,3.47946064787713e-15,9.841378982346e-12,3.36651415945821e-09,3.319853749814e-07,1.33459771268095e-05,0.000262283303255963,0.00280876104757722,0.0175690728808058,0.0671963114288901,0.161906293413675,0.250243596586934,0.250243596586935,0.161906293413676,0.0671963114288902,0.0175690728808058,0.00280876104757723,0.000262283303255964,1.33459771268096e-05,3.31985374981403e-07,3.36651415945822e-09,9.84137898234603e-12,3.47946064787715e-15,9.39019368904201e-17,3.71497415276238e-13,1.71866492796488e-10,2.26746167348063e-08,1.21765974544258e-06,3.20950056527462e-05,0.000464718718779395,0.0039766089291813,0.0211263444089675,0.0720693640171783,0.161459512867,0.24087011554664,0.24087011554664,0.161459512867,0.0720693640171783,0.0211263444089676,0.00397660892918132,0.000464718718779396,3.2095005652746e-05,1.21765974544258e-06,2.26746167348062e-08,1.71866492796487e-10,3.71497415276239e-13,9.39019368904203e-17,2.48069426039362e-18,1.34454764966355e-14,8.24280944316385e-12,1.42429323798799e-09,9.98675557331449e-08,3.44341361230812e-06,6.55755869433383e-05,0.000744202576360435,0.00530219801568222,0.0245976656571212,0.0762295322063031,0.160586545613795,0.232470735630078,0.232470735630078,0.160586545613794,0.076229532206303,0.0245976656571213,0.00530219801568221,0.000744202576360434,6.55755869433384e-05,3.44341361230814e-06,9.9867555733145e-08,1.42429323798803e-09,8.2428094431638e-12,1.34454764966358e-14,2.4806942603936e-18,6.4325474388018e-20,4.69176556950034e-16,3.74590103517651e-13,8.32660984388235e-11,7.47936258461369e-09,3.30486444992652e-07,8.09358405714514e-06,0.000118828538140179,0.00110430592785759,0.00675245970903014,0.027935784767881,0.0797733660115996,0.159418193661309,0.224888629750676,0.224888629750677,0.159418193661309,0.0797733660115995,0.0279357847678809,0.00675245970903015,0.00110430592785759,0.000118828538140179,8.09358405714522e-06,3.30486444992651e-07,7.47936258461373e-09,8.32660984388211e-11,3.74590103517655e-13,4.69176556950024e-16
                ,6.43254743880167e-20,1.64080700811783e-21,1.58556094496627e-17,1.62408012997242e-14,4.57342587132617e-12,5.17845946718978e-10,2.88217515404764e-08,8.90908886862122e-07,1.65799816306735e-05,0.000196512943984825,0.00154470733986608,0.0082957475577233,0.0311117701835012,0.0827868367156218,0.158046953209021,0.217999971815577,0.217999971815577,0.158046953209021,0.082786836715622,0.0311117701835013,0.00829574755772331,0.00154470733986608,0.000196512943984828,1.65799816306734e-05,8.90908886862123e-07,2.88217515404765e-08,5.1784594671898e-10,4.57342587132612e-12,1.62408012997244e-14,1.58556094496628e-17,1.6408070081178e-21,4.12460748901824e-23,5.20844959196087e-19,6.75529022367005e-16,2.37806485577785e-13,3.34750123980125e-11,2.31251841207423e-09,8.88129071310601e-08,2.05962210395342e-06,3.05598030608964e-05,0.000302557025817064,0.00206205105130787,0.00990346170232057,0.0341098477260921,0.0853448082720808,0.156538993757598,0.21170556988048,0.211705569880479,0.156538993757598,0.0853448082720808,0.0341098477260922,0.00990346170232059,0.00206205105130788,0.000302557025817062,3.05598030608961e-05,2.05962210395342e-06,8.88129071310592e-08,2.31251841207424e-09,3.3475012398012e-11,2.37806485577785e-13,6.75529022367006e-16,5.20844959196088e-19,4.12460748901834e-23,1.02332712980547e-24,1.66814437557858e-20,2.70805470926238e-17,1.17793779062248e-14,2.03665767977085e-12,1.72430556674529e-10,8.11740904012238e-09,2.31203426432292e-07,4.22772574838773e-06,5.18271264336689e-05,0.000439964966774623,0.0026508242383102,0.0115507389467772,0.0369234629580443,0.0875116813586241,0.15494209651486,0.205924936669113,0.205924936669113,0.154942096514859,0.0875116813586238,0.0369234629580443,0.0115507389467771,0.0026508242383102,0.00043996496677462,5.18271264336686e-05,4.22772574838776e-06,2.3120342643229e-07,8.11740904012221e-09,1.72430556674527e-10,2.0366576797708e-12,1.17793779062252e-14,2.7080547092624e-17,1.66814437557856e-20,1.02332712980544e-24,2.50903763463489e-26,5.22236620086274e-22,1.05029419347474e-18,5.58711397864998e-16,1.17402925510515e-13,1.204744586548e-11,6.87108338721218e-10,2.3738227773657e-08,5.27831519280098e-07,7.89697808672319e-06,8.2200255624104e-05,0.000610754833551101,0.00330413453843528,0.0132165740156021,0.0395523697665596,0.0893424975043867,0.153291013399711,0.200592006439022,0.200592006439022,0.153291013399711,0.0893424975043864,0.0395523697665598,0.0132165740156021,0.00330413453843529,0.000610754833551099,8.22002556241036e-05,7.89697808672308e-06,5.27831519280094e-07,2.37382277736569e-08,6.87108338721227e-10,1.20474458654796e-11,1.17402925510517e-13,5.58711397865001e-16,1.05029419347473e-18,5.22236620086294e-22,2.50903763463496e-26,6.08601956842486e-28,1.60158683497409e-23,3.95375221023568e-20,2.54865378937616e-17,6.44790652485418e-15,7.94172070052e-13,5.43146964739709e-11,2.25148478966052e-09,6.01757032994683e-08,1.08519930476596e-06,1.36665984891848e-05,0.00012342075661244,0.00081599141259661,0.0040143425017802,0.014883622220691,0.0420005199741626,0.0908841555525884,0.151611146260108,0.195651987041363,0.195651987041363,0.151611146260108,0.0908841555525883,0.0420005199741626,0.0148836222206911,0.00401434250178023,0.000815991412596617,0.00012342075661244,1.36665984891851e-05,1.08519930476593e-06,6.01757032994704e-08,2.25148478966046e-09,5.43146964739723e-11,7.94172070051973e-13,6.44790652485435e-15,2.54865378937619e-17,3.95375221023567e-20,1.60158683497406e-23,6.08601956842503e-28,1.46183987386951e-29,4.82046794020053e-25,1.44860943155154e-21,1.1222752068271e-18,3.38985344324827e-16,4.96808852919782e-14,4.03763858169525e-12,1.98911852602771e-10,6.3258971885489e-09,1.36034242157488e-07,2.04889743608146e-06,2.22117714324759e-05,0.000177072928799239,0.00105587901690182,0.00477354488182335,0.0165378441425695,0.0442745552022767,0.0921765791700608,0.149921111763571,0.19105900966199,0.191059009661991,0.149921111763571,0.0921765791700607,0.0442745552022769,0.0165378441425694,0.00477354488182334,0.00105587901690183,0.00017707292879924,2.22117714324758e-05,2.04889743608145e-06,1.36034242157489e-07,6.32589718854877e-09,1.98911852602783e-10
                ,4.03763858169516e-12,4.9680885291978e-14,3.3898534432484e-16,1.12227520682709e-18,1.44860943155153e-21,4.82046794020074e-25,1.46183987386944e-29,3.47984175873442e-31,1.42619784586328e-26,5.17807032944937e-23,4.78554184965251e-20,1.71281771102805e-17,2.9638784179822e-15,2.83940006653088e-13,1.64840897591814e-11,6.18241895690539e-10,1.57040564138077e-08,2.80044492613673e-07,3.60531021130439e-06,3.42573777291079e-05,0.000244526689086903,0.00132988590557214,0.00557392456121845,0.0181680901155516,0.0463827417911578,0.0932537686045957,0.148234554399296,0.186774348862019,0.18677434886202,0.148234554399296,0.0932537686045956,0.0463827417911577,0.0181680901155516,0.00557392456121847,0.00132988590557215,0.000244526689086903,3.42573777291084e-05,3.60531021130444e-06,2.80044492613676e-07,1.57040564138073e-08,6.18241895690539e-10,1.64840897591815e-11,2.83940006653081e-13,2.96387841798241e-15,1.71281771102796e-17,4.78554184965239e-20,5.17807032944965e-23,1.42619784586334e-26,3.47984175873452e-31,8.21525089317461e-33,4.15363486080958e-28,1.80948107070113e-24,1.9815155999927e-21,8.34667698152679e-19,1.69342711035748e-16,1.89851804100466e-14,1.28906481596393e-12,5.65656520410223e-11,1.68304580540452e-09,3.52208013940233e-08,5.33415216280825e-07,5.98050649787147e-06,5.05502434350226e-05,0.000326902972632911,0.0016368797268343,0.00640799021834472,0.0197656808338277,0.0483342272953843,0.0941447167949657,0.146561444171409,0.182765056859731,0.182765056859731,0.146561444171409,0.0941447167949656,0.0483342272953842,0.0197656808338276,0.00640799021834474,0.0016368797268343,0.000326902972632912,5.05502434350228e-05,5.9805064978714e-06,5.33415216280834e-07,3.52208013940234e-08,1.68304580540449e-09,5.65656520410227e-11,1.28906481596391e-12,1.89851804100464e-14,1.69342711035734e-16,8.34667698152679e-19,1.98151559999275e-21,1.80948107070118e-24,4.15363486080948e-28,8.21525089317468e-33,1.92466462704609e-34,1.19224627213292e-29,6.19285969807343e-26,7.98612726053366e-23,3.93454509020476e-20,9.30035350770125e-18,1.21224441543014e-15,9.56136384543473e-14,4.8741129632429e-12,1.68610629070289e-10,4.1082224808527e-09,7.25848186342948e-08,9.51757834977589e-07,9.43659882152018e-06,7.18325261253053e-05,0.000425058589908132,0.00197526037066304,0.00726872948099339,0.0213240141473573,0.0501385283010918,0.0948741922257738,0.144909016037457,0.179002903097351,0.179002903097351,0.144909016037457,0.0948741922257739,0.0501385283010917,0.0213240141473571,0.0072687294809934,0.00197526037066306,0.000425058589908128,7.18325261253058e-05,9.43659882152019e-06,9.51757834977587e-07,7.25848186342945e-08,4.1082224808527e-09,1.68610629070291e-10,4.87411296324292e-12,9.56136384543489e-14,1.21224441543021e-15,9.30035350770122e-18,3.9345450902048e-20,7.98612726053356e-23,6.19285969807339e-26,1.19224627213289e-29,1.9246646270461e-34,4.47715547387567e-36,3.37645614313547e-31,2.07905897141853e-27,3.13947664479917e-24,1.79885491623733e-21,4.92546510969889e-19,7.41999359806507e-17,6.756677274657e-15,3.97580595847154e-13,1.58836098124636e-11,4.47428715343641e-10,9.15405574631393e-09,1.39279168955996e-07,1.60639369554261e-06,1.42660923242469e-05,9.88180491761124e-05,0.000539586584627188,0.0023430821117604,0.00814969685535192,0.0228382121000913,0.0518051835495602,0.0954634005614293,0.143282456993176,0.175463541811866,0.175463541811866,0.143282456993176,0.0954634005614295,0.0518051835495604,0.0228382121000913,0.00814969685535191,0.00234308211176041,0.000539586584627186,9.88180491761134e-05,1.42660923242469e-05,1.60639369554263e-06,1.39279168955995e-07,9.15405574631372e-09,4.47428715343635e-10,1.58836098124638e-11,3.97580595847151e-13,6.75667727465707e-15,7.41999359806486e-17,4.92546510969897e-19,1.79885491623735e-21,3.13947664479918e-24,2.07905897141857e-27,3.37645614313545e-31,4.47715547387578e-36,1.03460750057697e-37,9.44341465958425e-33,6.85628075892456e-29,1.20604455076113e-25,7.99509447791516e-23,2.52248280716808e-20,4.36817181620153e-18,4.5666982468007e-16,3.0838286870053e-14,1.41422893612658e-12,4.57663671231043e-11,1.07706078938903e-09,1.88822597683521e-08,2.5146098808388e-07,2.58493765894942e-06
                ,2.07848517573454e-05,0.000132172632866898,0.000670828061978702,0.00273816089693534,0.0090450541548496,0.024304812864243,0.053343524531701,0.0959305403581016,0.141685413249944,0.172125851992443,0.172125851992443,0.141685413249944,0.0959305403581013,0.0533435245317011,0.0243048128642431,0.00904505415484962,0.00273816089693534,0.000670828061978709,0.000132172632866898,2.07848517573454e-05,2.58493765894935e-06,2.5146098808388e-07,1.88822597683519e-08,1.07706078938901e-09,4.57663671231037e-11,1.41422893612661e-12,3.08382868700538e-14,4.56669824680058e-16,4.36817181620149e-18,2.52248280716809e-20,7.99509447791537e-23,1.20604455076115e-25,6.85628075892456e-29,9.44341465958382e-33,1.034607500577e-37
        };
        const double * quads(int i)
        {
                // i must be divisible by two.
                if(i < 52){
                        if (! (i % 2)) { /* x is odd */
                                return  full_gh_quads + ((i/2)-1)*(i/2);
                        }else {
                                throw std::invalid_argument( "Quadrature points can only be pairs" );
                        }
                }else{
                        throw std::invalid_argument( "Use maximum 50 Quad pts." );
                }
                return full_gh_quads;
        }

        const double * weights(int i)
        {
                // i must be divisible by two.
                if(i < 52){
                        if (! (i % 2)) { /* x is odd */
                                return  full_gh_weights + ((i/2)-1)*(i/2);
                        }else {
                                throw std::invalid_argument( "Quadrature points can only be pairs" );
                        }
                }else{
                        throw std::invalid_argument( "Use maximum 50 Quad pts." );
                }
                return full_gh_weights;
        }
}
