% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemfit.R
\name{z3_itemf}
\alias{z3_itemf}
\title{Z3 statistic.}
\usage{
z3_itemf(data, zita, patterns)
}
\arguments{
\item{data}{a data frame or a matrix with the test.}

\item{zita}{a list of estimations of the parameters of the items (discrimination,difficulty, guessing).}

\item{patterns}{matrix of patterns response, the frequency of each pattern and the latent traits.}
}
\description{
Calculates the values of statistical Z3 for items.
}
\examples{

#Simulates a test and returns a list:
test <- simulateTest()

#the simulated data:
data <- test$test

#model:
mod <- irtpp(dataset = data,model = "3PL")

#latent trait:
zz <- parameter.matrix(mod$z)
p_mat <- mod$prob_mat
traits <- individual.traits(model="3PL",method = "EAP",dataset = data,itempars = zz,
probability_matrix=p_mat)

#Z3 PERSONFIT-Statistic
z3_itemf(data = data,zita = mod$z,patterns = traits)

}
\author{
SICS Research, National University of Colombia \email{ammontenegrod@unal.edu.co}
}
\references{
Fritz Drasgow, Michael V. Levine and Esther A. Williams (1985). Appropiateness measurement with polychotomous item response models and standarized indices.
}
\seealso{
\code{\link{z3_personf}}
}

