% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sundur.R
\name{sundur}
\alias{sundur}
\title{QC for Sunshine Duration (SS)}
\usage{
sundur(
  element = "SS",
  maxseq = 3,
  blocksizeround = 20,
  blockmanymonth = 15,
  blockmanyyear = 180,
  roundmax = 10,
  inisia = FALSE
)
}
\arguments{
\item{element}{two-letters ECA&D code for the element (SS for sunshine duration)}

\item{maxseq}{maximum number of consecutive repeated values, for flat function (11.1,11.1,11.1 would be 3 consecutive values). Passed on to flat(). See ?flat for details}

\item{blocksizeround}{maximum number of values in a month with the same decimal, FUNCTION: rounding()}

\item{blockmanymonth}{maximum number of equal values in a month, FUNCTION: toomany()}

\item{blockmanyyear}{maximum number of equal values in a year, FUNCTION: toomany()}

\item{roundmax}{maximum number of consecutive decimal part value, for flat() function (10.0, 11.0, 12.0 would be 3 consecutive values)}

\item{inisia}{logical flag. If it is TRUE inithome() will be called}
}
\value{
results of QC for SS
}
\description{
This function will centralize temperature-like QC routines. Will create a file in the folder QC
with an additional 0/1 column, where "1" means test failed
}
\examples{
#Set a temporal working directory:
wd <- tempdir()
wd0 <- setwd(wd)
#Create subdirectory where raw data files have to be located
dir.create(file.path(wd, 'raw'))
options("homefolder"='./'); options("blend"=FALSE)
#Extract the ECA&D data and station files from the example data folder
path2sslist<-system.file("extdata", "ECA_blend_source_ss.txt", package = "INQC")
sslist<-readr::read_lines_raw(path2sslist)
readr::write_lines(sslist,'ECA_blend_source_ss.txt')
path2ssdata<-system.file("extdata", "SS_SOUID132728.txt", package = "INQC")
ssdata<-readr::read_lines_raw(path2ssdata)
readr::write_lines(ssdata, file=paste(wd,'/raw/SS_SOUID132728.txt',sep=''))
#Perform QC of Sunshine Duration data
sundur(inisia=TRUE)
#Remove some temporary files
list = list.files(pattern = "Rfwf")
file.remove(list)
#Return to user's working directory:
setwd(wd0)
#The QC results can be found in the directory:
print(wd)
}
