% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_modify_pops.R
\name{data_modify_pops}
\alias{data_modify_pops}
\title{Modify Populations within IFC_data Object}
\usage{
data_modify_pops(obj, pops, display_progress = TRUE, ...)
}
\arguments{
\item{obj}{an `IFC_data` object extracted by ExtractFromDAF(extract_features = TRUE) or ExtractFromXIF(extract_features = TRUE).}

\item{pops}{a list of population(s) to modify in 'obj'. Each element of this list will be coerced by \code{\link{buildPopulation}}.}

\item{display_progress}{whether to display a progress bar. Default is TRUE.}

\item{...}{Other arguments to be passed.}
}
\value{
an IFC_data object with pops modified.
}
\description{
Modify populations in an already existing `IFC_data` object.
}
\details{
pops names should be present in names(obj$pops), otherwise an error will be raised.\cr
Note that If you want to rename pops, you should do it by changing 'name' member,
e.g. pops[[1]]$name <- "bar" while names(pops[[1]]) is "foo" and "foo" is part of names(obj$pops).
However, new names should not be present in 'obj'.
}
\keyword{internal}
