% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotdisc.R
\name{plotdisc}
\alias{plotdisc}
\title{Plot spatial discretization matrix.}
\usage{
plotdisc(discmatrix, group)
}
\arguments{
\item{discmatrix}{A matrix of spatial discretization}

\item{group}{A vector of groups}
}
\value{
A data frame of spatial discretization matrix, which
includes mean Q values in each group.
}
\description{
Plot spatial discretization matrix.
}
\examples{
library(GD)
f1 <- formula(NDVIchange ~ Tempchange + Precipitation + Popdensity)
odc1 <- optidisc(f1, ndvi_40, discmethod = "quantile", discitv = c(3:20))
xvar <- all.vars(f1)[-1]
nx <- length(xvar)
dm <- do.call(data.frame, lapply(1:nx, function(u) odc1[[u]]$qv.matrix))
names(dm) <- xvar
pd <- plotdisc(discmatrix = dm, group = rep(1:6, each = 3))

}
