% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_equivalence_ave.R
\name{equivalence_ave}
\alias{equivalence_ave}
\title{Checking the optimality of a  design with respect to the optim-on-the-average criterion}
\usage{
equivalence_ave(fimfunc, x, w, lx, ux, prior, param,
  maxeval_equivalence = 6000, plot_sensitivity = TRUE, ...)
}
\arguments{
\item{fimfunc}{Fisher information matrix. Can be the name of the Fisher information matrix from FIM family functions available in this package as a
character string or a function that returns the information matrix. See "Details" of \code{\link{mica}}.}

\item{x}{a vector of design points. If the  model has \eqn{n} explanatory variables, let \eqn{x_{ij}}
 be the \eqn{j}th component of the $\eqn{i}th design point.
The argument \code{x} is \eqn{x = (x_{11}, x_{21},..., x_{k1},..., x_{1n}, x_{2n},... x_{kn})}.
See "Examples" on how to set this argument when the design space does not have one dimension, e.g. is of two-dimension.}

\item{w}{a vector of design weights}

\item{lx}{lower bound of the design space \eqn{\chi}}

\item{ux}{upper bound of the design space \eqn{\chi}}

\item{prior}{a vector of the probability measure \eqn{\pi}.}

\item{param}{a matrix for set of parameters, i.e. support of \eqn{\pi}. Every row is is a vector of values of a parameter.
The number of its rows must be equal to the length of \code{prior}.}

\item{maxeval_equivalence}{maximum number of evaluations (\code{maxeval})  that will be passed to optimization
function \code{\link[nloptr]{directL}} to find the maximum of the sensitivity function required for calculating ELB.
 See "Details" of \code{\link{equivalence}}.}

\item{plot_sensitivity}{\code{logical}, if \code{TRUE}, the sensitivity function will be plotted.}

\item{...}{further argument to be passed to \code{fimfunc}}
}
\value{
an object of class \code{'equivalence'} that is a list contains:
 \describe{
 \item{\code{max_deriv}}{maximum of the sensitivity function}
 \item{\code{ELB}}{Efficiency lower bound. If it is negative,
  then the value of \code{maxeval_equivalence} should be increased to find the global maximum.}
 \item{\code{crtval}}{criterion value}
 }
}
\description{
Let \eqn{\Theta}  be the set of plausible parameter values and weighted by a probability measure
\eqn{\pi}, the measure having support in the parameter space \eqn{\Theta}, and \eqn{\Psi(\xi, \theta) =|M(\xi, \theta)|}.
A design \eqn{\xi^*}{\xi*} is optimum-on-the-average with respect to prior \eqn{\pi}  if
 the following inequality holds for all \eqn{\boldsymbol{x} \in \chi}{x belong to \chi}
 \deqn{c(\boldsymbol{x}, \pi, \xi^*) = \int_{\pi} tr M^{-1}(\xi^*, \theta)I(\boldsymbol{x}, \theta)\pi(\theta) d(\theta)-p \leq 0,}{
         c(x, \pi, \xi*)  = integration over \pi with integrand tr M^-1(\xi*, \theta)I(x, \theta)\pi(\theta) d(\theta)-p <= 0}
          with equality at all support points of \eqn{\xi^*}{\xi*}.
           Here, \eqn{p} is the number of model parameters.
}
\examples{
equivalence_ave(fimfunc ="FIM_logistic",lx = -5, ux = 5, x = c(0.2603688, 1, 1.739631),
                      w = c(0.2750147, 0.4499705, 0.2750148),  prior = c(.25, .25, .25, .25),
                      param =  matrix(c(0.5, 1.5, 0.5, 1.5, 4.0, 4.0, 5.0, 5.0), 4, 2))
}
\seealso{
\code{\link{equivalence}} and \code{\link{equivalence_multiple}}.
}

