% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ID_functions.R
\name{FindMaxRepeatDel}
\alias{FindMaxRepeatDel}
\title{Return the number of repeat units in which a deletion is embedded}
\usage{
FindMaxRepeatDel(context, rep.unit.seq, pos)
}
\arguments{
\item{context}{A string that embeds \code{rep.unit.seq} at position
\code{pos}}

\item{rep.unit.seq}{A substring of \code{context} at \code{pos}
to \code{pos + nchar(rep.unit.seq) - 1}, which is the repeat
 unit sequence.}

\item{pos}{The position of \code{rep.unit.seq} in \code{context}.}
}
\value{
The number of repeat units in which \code{rep.unit.seq} is
embedded, not including
the input \code{rep.unit.seq} in the count.
}
\description{
Return the number of repeat units in which a deletion is embedded
}
\details{
This function is primarily for internal use, but we export it
to document the underlying logic.

For example \code{FindMaxRepeatDel("xyaczt", "ac", 3)}
returns 0.

If
\code{substr(context, pos, pos + nchar(rep.unit.seq) - 1) != rep.unit.seq}
 then stop.

If this functions returns 0, then it is necessary to
  look for microhomology using the function
  \code{\link{FindDelMH}}.
  
\strong{Warning}\cr
This function depends on the variant caller having 
"aligned" the deletion within the context of the
repeat.

For example, a deletion of \code{CAG} in the repeat
\preformatted{
GTCAGCAGCATGT
}
can have 3 "aligned" representations as follows:
 \preformatted{
CT---CAGCAGGT
CTCAG---CAGGT
CTCAGCAG---GT
}
In these cases this function will return 2. (Please
not that the return value does not include the
\code{rep.uni.seq} in the count.)

However, the same deletion can also have an "unaligned" representation, such as
 \preformatted{
CTCAGC---AGGT
}
(a deletion of \code{AGC}).

In this case this function will return 1 (a deletion of \code{AGC}
in a 2-element repeat of \code{AGC}).
}
\section{ID classification}{

See
\url{https://github.com/steverozen/ICAMS/raw/master/data-raw/PCAWG7_indel_classification_2017_12_08.xlsx}
for additional information on ID (small insertion and deletion) mutation
classification.

See the documentation for \code{\link{Canonicalize1Del}} which first handles
deletions in homopolymers, then handles deletions in simple repeats with
longer repeat units, (e.g. \code{CACACACA}, see
\code{\link{FindMaxRepeatDel}}), and if the deletion is not in a simple
repeat, looks for microhomology (see \code{\link{FindDelMH}}).

See the code for unexported function \code{\link{CanonicalizeID}}
and the functions it calls for handling of insertions.
}

\examples{
FindMaxRepeatDel("xyACACzt", "AC", 3) # 1
FindMaxRepeatDel("xyACACzt", "CA", 4) # 0

}
