% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foopTTable.R
\name{sTpcteTab}
\alias{sTpcteTab}
\title{Table of Entropies, Function of Temperature for a Fixed Pressure}
\usage{
sTpcteTab(T1, T2, dT, p)
}
\arguments{
\item{T1}{initial Temperature [ K ]}

\item{T2}{final Temperature [ K ]}

\item{dT}{Temperature increment [ K ]}

\item{p}{Pressure [ MPa ]}
}
\value{
A table of Entropies for fixed p and a T Interval: T1:T2.
}
\description{
The function \code{sTpcteTab(T1, T2, dT, p)} returns a table of 
    entropies [kJ kg-1 K-1] for a fixed p [MPa] within a range of T [K]: T1:T2 [K]
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
T1 <- 275.
T2 <- 450.
dT <- 5.
p <- 5.
sTpcteTab(T1, T2, dT, p)

T1 <- 300.
T2 <- 500.
dT <- 10.
p <- 10.
Tabs <- sTpcteTab(T1, T2, dT, p)

}

