% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooOth.R
\name{TDs}
\alias{TDs}
\title{Temperature, Function of Density and Entropy}
\usage{
TDs(D, s)
}
\arguments{
\item{D}{Density [ kg m3 ]}

\item{s}{Entropy in [ kJ kg-1 K-1 ]}
}
\value{
The Temperature: T [ K ] and an Error Message (if an error occur: \link{errorCodes})
}
\description{
The function \code{TDs(D,s)} returns the water temperature, T [ K ],
     for given D [kg/m3] and s [ kJ kg-1 K-1 ].
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
D <- 838.025
s <- 2.56690919
TDs(D,s)

}

