% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censor_values.R
\name{censor_values}
\alias{censor_values}
\title{Censor values above or below a threshold}
\usage{
censor_values(
  value,
  censor_threshold = 0,
  censor_symbol = c("lte", "lt", "gt", "gte")
)
}
\arguments{
\item{value}{'numeric' vector. Values to censor.}

\item{censor_threshold}{'numeric' value.
Threshold to censor values on. Default is 0.}

\item{censor_symbol}{'character' string.\cr
Inequality symbol to censor values based on censor_threshold.\cr
Accepted values are \code{"gt"} (greater than),\cr
\code{"gte"} (greater than or equal to),\cr
\code{"lt"} (less than),\cr
or \code{"lte"} (less than or equal to).\cr
Default is \code{"lte"}.}
}
\value{
'numeric' vector with censored values replaced with \code{NA}
}
\description{
Replaces values in a vector with \code{NA} when above or below a censor level.\cr
Censoring is \verb{values censor_symbol censor_threshold} are censored,
for example with the defaults (values lte 0 set to \code{NA}) all values <= 0 are
replaced with \code{NA}.
}
\examples{
censor_values(value = seq.int(1, 10, 1), censor_threshold = 5)

}
\keyword{preprocessing-data}
