% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hmsc.R
\name{Hmsc}
\alias{Hmsc}
\title{Hmsc}
\usage{
Hmsc(
  Y,
  XFormula = ~.,
  XData = NULL,
  X = NULL,
  XScale = TRUE,
  XSelect = NULL,
  XRRRData = NULL,
  XRRRFormula = ~. - 1,
  XRRR = NULL,
  ncRRR = 2,
  XRRRScale = TRUE,
  YScale = FALSE,
  studyDesign = NULL,
  ranLevels = NULL,
  ranLevelsUsed = names(ranLevels),
  TrFormula = NULL,
  TrData = NULL,
  Tr = NULL,
  TrScale = TRUE,
  phyloTree = NULL,
  C = NULL,
  distr = "normal",
  truncateNumberOfFactors = TRUE
)
}
\arguments{
\item{Y}{a matrix of species occurences or abundances}

\item{XFormula}{a \code{\link{formula}}-class object for fixed effects
(linear regression)}

\item{XData}{a data frame of measured covariates for fixed effects with
\code{\link{formula}}-based specification}

\item{X}{a matrix of measured covariates for fixed effects with direct specification}

\item{XScale}{a boolean flag indicating whether to scale covariates for the fixed effects}

\item{XSelect}{a list describing how variable selection is to be applied}

\item{XRRRData}{a data frame of covariates for reduced-rank regression}

\item{XRRRFormula}{\code{\link{formula}} for reduced-rank regression}

\item{XRRR}{a matrix of covariates for reduced-rank regression}

\item{ncRRR}{number of covariates (linear combinations) for reduced-rank regression}

\item{XRRRScale}{a boolean flag indicating whether to scale covariates for reduced-rank regression}

\item{YScale}{a boolean flag whether to scale responses for which normal distribution is assumed}

\item{studyDesign}{a data frame of correspondence between sampling units and units on different levels of latent
factors}

\item{ranLevels}{a named list of \code{HmscRandomLevel}-class objects, specifying the structure and data for random
levels}

\item{ranLevelsUsed}{a vector with names of levels of latent factors that are used in the analysis}

\item{TrFormula}{a \code{\link{formula}}-class object for regression
dependence of \eqn{\beta_{kj}} coefficients on species traits}

\item{TrData}{a data frame of measured species traits for
\code{\link{formula}}-based specification}

\item{Tr}{a matrix of measured traits for direct specification}

\item{TrScale}{a boolean flag whether to scale values of species traits}

\item{phyloTree}{a phylogenetic tree (object of class \code{phylo} or \code{corPhyl}) for species in \code{Y}}

\item{C}{a phylogenic correlation matrix for species in \code{Y}}

\item{distr}{a string shortcut or \eqn{n_s \times 2} matrix specifying the observation models}

\item{truncateNumberOfFactors}{logical, reduces the maximal number of latent factor to be at most the number of species}
}
\value{
An object of \code{Hmsc} class without any posterior samples.
}
\description{
Creates an \code{Hmsc}-class object
}
\details{
Matrix \eqn{Y} may contain missing values, but it is not recommended to add a
  species/sampling unit with fully missing data, since those do not bring any new additional information.

  Only one of \code{XFormula}-\code{XData} and \code{X} arguments can be specified. Similar requirement applies to
  \code{TrFormula}-\code{TrData} and \code{Tr}. It is recommended to use the specification with \code{\link{formula}},
  since that information enables additional features for postprocessing of the fitted model.

  As default, scaling is applied for \code{X} and \code{Tr} matrices, but not for \code{Y} matrix. If the \code{X} and/or \code{Tr} matrices are
  scaled, the estimated parameters are back-transformed so that the estimated parameters correspond to the original
  \code{X} and \code{Tr} matrices, not the scaled ones. In contrast, if \code{Y} is scaled, the estimated parameters are not
  back-transformed because doing so is not possible for all model parameters. Thus, the estimated parameters
  correspond to the scaled \code{Y} matrix, not the original one. If the \code{Y} matrix is scaled, the predictions
  generated by \code{predict} are back-transformed, so that the predicted \code{Y} matrices are directly comparable
  to the original \code{Y} matrix. If default priors are assumed, it is recommended that all matrices (\code{X}, \code{Tr} and \code{Y}) are scaled.

  The object \code{XSelect} is a list. Each object of the list \code{Xsel = XSelect[[i]]} is a named list with objects
  \code{Xsel$covGroup}, \code{Xsel$spGroup} and \code{Xsel$q}. The parameter \code{covGroup} is a vector containing
  the columns of the matrix \code{X} for which variable selection is applied. The parameter \code{spGroup}
  is a vector of length equal to the number of species \code{ns}, with values \code{1,...,ng},
  where \code{ng} is the number of
  groups of species for which variable selection is applied simultanously. The parameter
  \code{q} is a vector of length \code{ng}, containing the prior probabilities by which the variables
  are to be included.
  For example, choosing \code{covGroup = c(2,3)}, \code{spGroup = rep(1,ns)} and \code{q=0.1} either includes
  or excludes both of the covariates 2 and 3 simultaneously for all species. For another example, choosing \code{covGroup = c(2,3)},
  \code{spGroup = 1:ns} and \code{q=rep(0.1,ns)} either includes
  or excludes both of the covariates 2 and 3 separately for each species.

  The included random levels are specified by the \code{ranLevels} and \code{ranLevelsUsed} arguments. The
  correspondence between units of each random level and rows of \code{Y} must be specified by a column of
  \code{studyDesign}, which corresponds to the name of a list item in \code{ranLevels}. It is
  possible to provide an arbitrary number of columns in \code{studyDesign} that are not listed in \code{ranLevels}.
  These do not affect the model formulation or fitting scheme, but can be utilized during certain functions
  postprocessing the results of statistical model fit.

  The \code{distr} argument may be either a matrix, a string literal, or a vector of string literals. In the case of
  a matrix, the dimension must be \eqn{n_s \times 2}, where the first column defines the family of the observation
  model and the second argument defines the dispersion property. The elements of the first column must take values
  1-normal, 2-probit and 3-Poisson with log link function. The second argument stands for the dispersion parameter
  being fixed (0) or estimated (1). The default fixed values of the dispersion parameters are 1 for normal and probit,
  and 0.01 for Poisson (implemented as a limiting case of lognormally-overdispersed Poisson). Alternatively, a string
  literal shortcut can be given as a value to the \code{distr} argument, simultaniously specifying similar class of
  observation models for all species. The available shortcuts are \code{"normal"}, \code{"probit"}, \code{"poisson"},
  \code{"lognormal poisson"}. If \code{distr} is a vector of string literals, each element corresponds to one species,
  should be either \code{"normal"}, \code{"probit"}, \code{"poisson"}, \code{"lognormal poisson"},
and these can be abbreviated as long as they are unique strings.
  The matrix argument and the vector of string literals allows specifying different observation
  models for different species.

  By default this constructor assigns default priors to the latent factors. Those priors are designed to be
  reasonably flat assuming that the covariates, species traits and normally distributed responses are scaled.
  In case when other priors needed to be specified, a call of \code{setPriors.Hmsc} methods should be made,
  where the particular priors may be specified.
}
\examples{
# Creating a Hmsc object without phylogeny, trait data or random levels
m = Hmsc(Y=TD$Y, XData=TD$X, XFormula=~x1+x2)

# Creating a Hmsc object with phylogeny and traits
m = Hmsc(Y=TD$Y, XData=TD$X, XFormula=~x1+x2,
TrData=TD$Tr, TrFormula=~T1+T2, phyloTree=TD$phylo)

# Creating a Hmsc object with 2 nested random levels (50 sampling units in 20 plots)
studyDesign = data.frame(sample = as.factor(1:50), plot = as.factor(sample(1:20,50,replace=TRUE)))
rL1 = HmscRandomLevel(units=TD$studyDesign$plot)
rL2 = HmscRandomLevel(units=TD$studyDesign$sample)
m = Hmsc(Y=TD$Y, XData=TD$X, XFormula=~x1+x2,
studyDesign=studyDesign,ranLevels=list("sample"=rL1,"plot"=rL2))

}
\seealso{
\code{\link{HmscRandomLevel}}, \code{\link{sampleMcmc}}, \code{\link{setPriors.Hmsc}}
}
