% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Power.law.network.R
\name{Power.law.network}
\alias{Power.law.network}
\title{Power law network}
\usage{
Power.law.network(p, s = 10, umin = 0.1, umax = 0.4, I2 = 0, I3 = 0)
}
\arguments{
\item{p}{The dimensions of the precision matrix.}

\item{s}{The number of sub-networks.}

\item{umin}{The lower bound of non-zero elements on non-diagonal elements.}

\item{umax}{The upper bound of non-zero elements on non-diagonal elements.}

\item{I2}{The replacement blocks for the precision matrix of the second subgroup.}

\item{I3}{The replacement blocks for the precision matrix of the third subgroup.}
}
\value{
A list including The precision matrices of three subgroups.
}
\description{
Generating three s-block power-law precision matrices
}
\examples{
p <- 20               # The dimension of the precision matrix
################ The true parameters ################
# Power law network
set.seed(2)
A.list <- Power.law.network(p,s=5,I2=c(1),I3=c(2))
Theta01 <- A.list$A1
Theta02 <- A.list$A2
Theta03 <- A.list$A3
sigma01 <- solve(Theta01)
sigma02 <- solve(Theta02)
sigma03 <- solve(Theta03)
Sigma0.list <- list(sigma01,sigma02,sigma03)
Theta0.list <- list(Theta01,Theta02,Theta03)

}
