% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RM_add.R
\name{RM_add}
\alias{RM_add}
\title{Create a results managment or add a value in a results managment to an object}
\usage{
RM_add(
  x = stop("An object with results managment must be provided"),
  RM = "RM",
  RMname = stop("A results managment name must be provided"),
  valuename = NULL,
  value = NULL
)
}
\arguments{
\item{x}{The object to add a results managment or a result in a results managment}

\item{RM}{The name of results managment stored}

\item{RMname}{The name of the results managment to be modified or created}

\item{valuename}{The name of the new value to be added}

\item{value}{The value to be added}
}
\value{
The original object with a new value in a results managment object or a new results managment
}
\description{
Return original object with a new value or a new results managment.
}
\details{
RM_add adds a results managment or a value in results managment to an object
}
\examples{
\dontrun{
library("HelpersMG")
# Let an object of class objclass being created
obj <- list(A=100, name="My object")
class(obj) <- "objclass"
# And now I create a RM to this object
obj <- RM_add(x=obj, RMname="NewAnalysis1")
RM_list(obj)
obj <- RM_add(x=obj, RMname="NewAnalysis2")
RM_list(obj)
obj <- RM_add(x=obj, RMname="NewAnalysis2", valuename="V1", value=100)
RM_get(x=obj, RMname="NewAnalysis2", valuename="V1")
obj <- RM_add(x=obj, RMname="NewAnalysis2", valuename="V1", value=200)
RM_get(x=obj, RMname="NewAnalysis2", valuename="V1")
obj <- RM_add(x=obj, RMname="NewAnalysis2", valuename="V2", value=300)
RM_get(x=obj, RMname="NewAnalysis2", valuename="V2")
RM_list(obj)
}
}
\seealso{
Other Results Managment: 
\code{\link{RM_delete}()},
\code{\link{RM_duplicate}()},
\code{\link{RM_get}()},
\code{\link{RM_list}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{Results Managment}
