% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inside.R
\name{inside}
\alias{inside}
\title{Search a string within files of a folder}
\usage{
inside(
  text = stop("A text to be searched for is necessary"),
  path = ".",
  pattern = "*\\\\.R$",
  showallfilenames = FALSE,
  ...,
  fixed = TRUE,
  ignore.case = FALSE
)
}
\arguments{
\item{text}{Text to search in files}

\item{path}{Path of the folder to search in}

\item{pattern}{Pattern for file names to search in}

\item{showallfilenames}{logical. Show all the filenames search for in}

\item{...}{Options for readLines(), example warn = FALSE}

\item{fixed}{logical. If TRUE, pattern is a string to be matched as is. Overrides all conflicting arguments (see gsub)}

\item{ignore.case}{logical. if FALSE, the pattern matching for text is case sensitive and if TRUE, case is ignored during matching.}
}
\value{
Return an invisible vector with filenames in which the pattern occurs
}
\description{
Search for a string inside the files of a folder and return where the string is found.\cr
The pattern for files that must be included uses regex for filtering.\cr
}
\details{
inside Search a string within files of a folder
}
\examples{
\dontrun{
library(HelpersMG)
# Search for files in path with names based on pattern that have the string search inside.
inside("embryogrowth", path=".", pattern="*\\\\.R$")
}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
