% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MovingWindow.R
\name{MovingWindow}
\alias{MovingWindow}
\title{Return a moving average of a vector.}
\usage{
MovingWindow(x, window, hole = "begin", fill = TRUE, FUN = mean)
}
\arguments{
\item{x}{The vector to analyze}

\item{window}{The window size}

\item{hole}{Should the returned vector have the same length than x}

\item{fill}{TRUE or FALSE, should the vector return NA}

\item{FUN}{Function to apply to the window}
}
\value{
A vector
}
\description{
Return a moving average of a vector./cr
hole parameter can be none, bothL, bothR, both, begin, end.
}
\details{
MovingWindow returns a moving average of a vector.
}
\examples{
MovingWindow(1:10, window = 4, fill = TRUE, hole="bothL")
MovingWindow(1:10, window = 4, fill = TRUE, hole="bothR")
MovingWindow(1:10, window = 4, fill = TRUE, hole="both")
MovingWindow(1:10, window = 4, fill = TRUE, hole="none")
MovingWindow(1:10, window = 4, fill = TRUE, hole="begin")
MovingWindow(1:10, window = 4, fill = TRUE, hole="end")
MovingWindow(1:10, window = 4, fill = TRUE, hole="end", FUN=sd)
}
\author{
Marc Girondot
}
