% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tide.info.R
\name{tide.info}
\alias{tide.info}
\title{Annual tide calendar for one particular location}
\usage{
tide.info(
  file = NULL,
  year = as.POSIXlt(Sys.time())$year + 1900,
  location = 0,
  latitude = NA,
  longitude = NA,
  tz = ""
)
}
\arguments{
\item{file}{An html file from the site \code{http://tides.mobilegeographics.com/}}

\item{year}{Year to get the calendar}

\item{location}{Code based on \code{http://tides.mobilegeographics.com/}}

\item{latitude}{The latitude of the tide information}

\item{longitude}{The longitude of the tide information}

\item{tz}{Timezone}
}
\value{
Return a data.frame with tide calendar:\cr
Level is the tide level, Tide is the High or Low Tide information and Date.Time is
the date/time in POSIXlt format.
}
\description{
The script extracts tide information from:\cr
\code{http://tides.mobilegeographics.com/} into a data.frame.\cr
The presence of XLM package is required for this function.\cr
}
\details{
tide.info gets the annual tide calendar for one particular location.
}
\examples{
\dontrun{
library("HelpersMG")
lat <- 5.74
long <- -54
Awala2004 <- tide.info(year=2004, longitude=long, latitude=lat, tz="America/Cayenne")
with(Awala2004, plot(Date.Time, Level, bty="n", las=1, type="l", 
xlab=paste("Year", as.POSIXlt(Date.Time[1])$year+1900), 
ylab="Tide level in m"))
latitude <- 45.3667
longitude <- -64.3833
NovaScotia <- tide.info(year=2018, longitude=longitude, 
                       latitude=latitude, tz="America/Halifax" )
with(NovaScotia, plot(Date.Time, Level, bty="n", las=1, type="l", xaxt="n", 
   xlab=paste("January", as.POSIXlt(Date.Time[1])$year+1900), 
   xlim=as.numeric(as.POSIXlt(as.Date(c("2018-01-01", "2018-01-31")))), 
   ylab="Tide level in m"))
axis(1, at=as.numeric(as.POSIXlt(seq(from=as.Date("2018-01-01"), 
                                     to=as.Date("2018-01-31"), by="1 day"))), 
labels=1:31)
segments(x0=as.numeric(as.POSIXlt(as.Date("2018-01-01"))), 
x1=as.numeric(as.POSIXlt(as.Date("2018-01-31"))), y0=0, y1=0, lty=2)
}
}
\seealso{
Other Periodic patterns of indices: 
\code{\link{index.periodic}()},
\code{\link{minmax.periodic}()},
\code{\link{moon.info}()},
\code{\link{sun.info}()}
}
\author{
Marc Girondot \email{marc.girondot@u-psud.fr}
}
\concept{Periodic patterns of indices}
\keyword{Tide}
