% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/madPlot.R
\name{madPlot}
\alias{madPlot}
\title{Mean Absolute Deviation Plot}
\usage{
madPlot(hvt.scoring, ...)
}
\arguments{
\item{hvt.scoring}{List. A list of hvt.scoring obtained from the scoreHVT
function.}

\item{...}{The ellipsis is passed to it as additional argument. (Used internally)}
}
\value{
Mean Absolute Deviation Plot
\item{mad_plot}{ggplot plot. A plot with percentage anomalies on y axis and mean absolute deviation values on xaxis. }
}
\description{
Function to create Mean Absolute Deviation Plot
}
\details{
This function plots percentage anomalies vs mean absolute deviation for test data. The plot helps in
deciding an optimal MAD value for the use case.
}
\examples{
data("EuStockMarkets")
dataset <- data.frame(date = as.numeric(time(EuStockMarkets)),
                     DAX = EuStockMarkets[, "DAX"],
                     SMI = EuStockMarkets[, "SMI"],
                     CAC = EuStockMarkets[, "CAC"],
                     FTSE = EuStockMarkets[, "FTSE"])
#adding this step especially for this function
rownames(EuStockMarkets) <- dataset$date
train <- EuStockMarkets[1:1302, ]
test <- EuStockMarkets[1303:1860, ]
hvt_summary <- list()
hvt_summary<- trainHVT(train,n_cells = 15, depth = 1, quant.err = 0.2,
                      distance_metric = "L1_Norm", error_metric = "mean", 
                      normalize = TRUE, quant_method = "kmeans")
score_var <- scoreHVT(test, hvt_summary, child.level = 2, mad.threshold = 0.2)
madPlot(hvt.scoring=score_var)
}
\seealso{
\code{\link{scoreHVT}}
}
\author{
Shubhra Prakash <shubhra.prakash@mu-sigma.com>
}
\keyword{internal}
