/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Graphics;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import ptolemy.plot.PlotBox;

public class Histogram
extends PlotBox {
    protected int _currentdataset = -1;
    protected Vector _points = new Vector();
    protected Vector _histogram = new Vector();
    private double _barwidth = 0.5;
    private double _baroffset = 0.15;
    private double _binWidth = 1.0;
    private double _binOffset = 0.5;
    private String _filename = null;
    private boolean _showing = false;

    public void addLegend(int n, String string) {
        this._checkDatasetIndex(n);
        super.addLegend(n, string);
    }

    public synchronized void addPoint(final int n, final double d) {
        Runnable runnable = new Runnable(){

            public void run() {
                Histogram.this._addPoint(n, d);
            }
        };
        this.deferIfNecessary(runnable);
    }

    public synchronized void addPoint(int n, double d, double d2, boolean bl) {
        this.addPoint(n, d2);
    }

    public synchronized void clear(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                Histogram.this._clear(bl);
            }
        };
        this.deferIfNecessary(runnable);
    }

    public synchronized void exportToPlot(PrintWriter printWriter, String string) {
        if (string == null) {
            printWriter.println("<?xml version=\"1.0\" standalone=\"yes\"?>");
            printWriter.println("<!DOCTYPE plot PUBLIC \"-//UC Berkeley//DTD PlotML 1//EN\"");
            printWriter.println("    \"http://ptolemy.eecs.berkeley.edu/xml/dtd/PlotML_1.dtd\">");
        } else {
            printWriter.println("<?xml version=\"1.0\" standalone=\"no\"?>");
            printWriter.println("<!DOCTYPE plot SYSTEM \"" + string + "\">");
        }
        printWriter.println("<plot>");
        printWriter.println("<!-- Ptolemy plot, version 5.3 , PlotML format. Exported from Histogram. -->");
        super.writeFormat(printWriter);
        printWriter.println("<barGraph width=\"" + this._barwidth * this._binWidth + "\" offset=\"" + this._baroffset * this._binWidth + "\"/>");
        for (int i = 0; i < this._points.size(); ++i) {
            String string2 = this.getLegend(i);
            if (string2 != null) {
                printWriter.println("<dataset name=\"" + string2 + "\" connected=\"no\">");
            } else {
                printWriter.println("<dataset connected=\"no\">");
            }
            Hashtable hashtable = (Hashtable)this._histogram.elementAt(i);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                Integer n2 = (Integer)hashtable.get(n);
                int n3 = (int)((double)n.intValue() * this._binWidth + this._binOffset);
                printWriter.println("<p x=\"" + n3 + "\" y=\"" + n2 + "\"/>");
            }
            printWriter.println("</dataset>");
        }
        printWriter.println("</plot>");
        printWriter.flush();
    }

    public synchronized void fillPlot() {
        Runnable runnable = new Runnable(){

            public void run() {
                Histogram.this._fillPlot();
            }
        };
        this.deferIfNecessary(runnable);
    }

    public synchronized void samplePlot() {
        this.clear(true);
        this.setTitle("Sample histogram");
        this.setXLabel("values");
        this.setYLabel("count");
        Random random = new Random();
        for (int i = 0; i <= 1000; ++i) {
            this.addPoint(0, 5.0 * Math.cos(Math.PI * (double)i / 500.0));
            this.addPoint(1, 10.0 * random.nextDouble() - 5.0);
            this.addPoint(2, 2.0 * random.nextGaussian());
        }
        this.repaint();
    }

    public synchronized void setBars(double d, double d2) {
        this._plotImage = null;
        this._barwidth = d;
        this._baroffset = d2;
    }

    public synchronized void setBinOffset(double d) {
        this._plotImage = null;
        this._binOffset = d;
    }

    public void setBinWidth(double d) {
        this._plotImage = null;
        this._binWidth = d;
    }

    public synchronized void write(Writer writer, String string) {
        PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(writer), false);
        this.exportToPlot(printWriter, string);
    }

    public synchronized void writeData(PrintWriter printWriter) {
        super.writeData(printWriter);
        for (int i = 0; i < this._points.size(); ++i) {
            String string = this.getLegend(i);
            if (string != null) {
                printWriter.println("<dataset name=\"" + string + "\">");
            } else {
                printWriter.println("<dataset>");
            }
            Vector vector = (Vector)this._points.elementAt(i);
            for (int j = 0; j < vector.size(); ++j) {
                Double d = (Double)vector.elementAt(j);
                printWriter.println("<p y=\"" + d + "\"/>");
            }
            printWriter.println("</dataset>");
        }
    }

    public synchronized void writeFormat(PrintWriter printWriter) {
        super.writeFormat(printWriter);
        printWriter.println("<barGraph width=\"" + this._barwidth + "\" offset=\"" + this._baroffset + "\"/>");
        printWriter.println("<bin width=\"" + this._binWidth + "\" offset=\"" + this._binOffset + "\"/>");
    }

    protected void _checkDatasetIndex(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Plot._checkDatasetIndex: Cannot give a negative number for the data set index.");
        }
        while (n >= this._points.size()) {
            this._points.addElement(new Vector());
            this._histogram.addElement(new Hashtable());
        }
    }

    protected void _drawBar(Graphics graphics, int n, long l, long l2, boolean bl) {
        if (bl) {
            if (l2 < (long)this._uly) {
                l2 = this._uly;
            }
            if (l2 > (long)this._lry) {
                l2 = this._lry;
            }
        }
        if (l2 <= (long)this._lry && l <= (long)this._lrx && l >= (long)this._ulx) {
            long l3;
            int n2 = (int)((double)l - this._barwidth * this._binWidth * this._xscale / 2.0 + (double)n * this._baroffset * this._binWidth * this._xscale);
            int n3 = (int)((double)n2 + this._barwidth * this._binWidth * this._xscale);
            if (n2 < this._ulx) {
                n2 = this._ulx;
            }
            if (n3 > this._lrx) {
                n3 = this._lrx;
            }
            if (n2 >= n3) {
                n3 = n2 + 1;
            }
            if ((long)this._lry < (l3 = (long)this._lry - (long)((0.0 - this._yMin) * this._yscale))) {
                l3 = this._lry;
            }
            if ((long)this._uly > l3) {
                l3 = this._uly;
            }
            if (this._yMin >= 0.0 || l2 <= l3) {
                graphics.fillRect(n2, (int)l2, n3 - n2, (int)(l3 - l2));
            } else {
                graphics.fillRect(n2, (int)l3, n3 - n2, (int)(l2 - l3));
            }
        }
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean bl) {
        super._drawPlot(graphics, bl);
        this._showing = true;
        for (int i = this._points.size() - 1; i >= 0; --i) {
            Hashtable hashtable = (Hashtable)this._histogram.elementAt(i);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                Integer n2 = (Integer)hashtable.get(n);
                this._drawPlotPoint(graphics, i, n, n2);
            }
        }
    }

    protected boolean _parseLine(String string) {
        if (super._parseLine(string)) {
            return true;
        }
        String string2 = new String(string.toLowerCase());
        if (string2.startsWith("dataset:")) {
            String string3;
            ++this._currentdataset;
            if (string2.length() > 0 && (string3 = string.substring(8).trim()) != null && string3.length() > 0) {
                this.addLegend(this._currentdataset, string3);
            }
            return true;
        }
        if (string2.startsWith("bars:") || string2.startsWith("bargraph:")) {
            String string4;
            int n = string.indexOf(",", 5);
            String string5 = null;
            if (n > 0) {
                string4 = string.substring(5, n).trim();
                string5 = string.substring(n + 1).trim();
            } else {
                string4 = string.substring(5).trim();
            }
            try {
                Double d = new Double(string4);
                double d2 = this._baroffset;
                if (string5 != null) {
                    d2 = new Double(string5);
                }
                this.setBars(d, d2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return true;
        }
        if (string2.startsWith("binwidth:")) {
            String string6 = string.substring(9).trim();
            try {
                Double d = new Double(string6);
                this.setBinWidth(d);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return true;
        }
        if (string2.startsWith("binoffset:")) {
            String string7 = string.substring(10).trim();
            try {
                Double d = new Double(string7);
                this.setBinOffset(d);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return true;
        }
        if (string2.startsWith("numsets:")) {
            return true;
        }
        if (string.startsWith("move:")) {
            string = string.substring(5, string.length()).trim();
        } else if (string.startsWith("move")) {
            string = string.substring(4, string.length()).trim();
        } else if (string.startsWith("draw:")) {
            string = string.substring(5, string.length()).trim();
        } else if (string.startsWith("draw")) {
            string = string.substring(4, string.length()).trim();
        }
        string = string.trim();
        int n = string.indexOf(",");
        if (n == -1) {
            n = string.indexOf(" ");
        }
        if (n == -1) {
            n = string.indexOf("\t");
        }
        if (n == -1) {
            try {
                Double d = new Double(string);
                this.addPoint(this._currentdataset, d);
                return true;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            String string8 = string.substring(n + 1).trim();
            try {
                Double d = new Double(string8);
                this.addPoint(this._currentdataset, d);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private void _addPoint(int n, double d) {
        double d2;
        int n2;
        this._plotImage = null;
        this._checkDatasetIndex(n);
        int n3 = (int)Math.round((d - this._binOffset) / this._binWidth);
        Integer n4 = new Integer(n3);
        Hashtable hashtable = (Hashtable)this._histogram.elementAt(n);
        if (hashtable.containsKey(n4)) {
            n2 = 1 + (Integer)hashtable.get(n4);
            hashtable.put(n4, new Integer(n2));
        } else {
            n2 = 1;
            hashtable.put(n4, new Integer(n2));
        }
        double d3 = (double)n3 * this._binWidth + this._binOffset;
        if (d3 < this._xBottom) {
            this._xBottom = d3;
        }
        if ((d2 = d3 + this._binWidth / 2.0) > this._xTop) {
            this._xTop = d2;
        }
        if ((double)n2 > this._yTop) {
            this._yTop = n2;
        }
        this._yBottom = 0.0;
        Vector vector = (Vector)this._points.elementAt(n);
        vector.addElement(new Double(d));
        Graphics graphics = this.getGraphics();
        if (this._showing && graphics != null) {
            int n5 = n;
            int n6 = n3;
            int n7 = n2;
            this._drawPlotPoint(graphics, n5, n6, n7);
        }
    }

    private void _clear(boolean bl) {
        this._plotImage = null;
        super.clear(bl);
        this._currentdataset = -1;
        this._points = new Vector();
        this._histogram = new Vector();
        this._filename = null;
        this._showing = false;
        if (bl) {
            this._barwidth = 0.5;
            this._baroffset = 0.15;
            this._binWidth = 1.0;
            this._binOffset = 0.5;
        }
    }

    private void _drawPlotPoint(Graphics graphics, int n, int n2, int n3) {
        if (this._usecolor) {
            int n4 = n % _colors.length;
            graphics.setColor(_colors[n4]);
        } else {
            graphics.setColor(this._foreground);
        }
        double d = n3;
        double d2 = this._binWidth * (double)n2 + this._binOffset;
        if (this._xlog) {
            if (d2 <= 0.0) {
                System.err.println("Can't plot non-positive X values when the logarithmic X axis value is specified: " + d2);
                return;
            }
            d2 = Math.log(d2) * _LOG10SCALE;
        }
        if (this._ylog) {
            if (d <= 0.0) {
                System.err.println("Can't plot non-positive Y values when the logarithmic Y axis value is specified: " + d);
                return;
            }
            d = Math.log(d) * _LOG10SCALE;
        }
        long l = (long)this._lry - (long)((d - this._yMin) * this._yscale);
        long l2 = (long)this._ulx + (long)((d2 - this._xMin) * this._xscale);
        this._drawBar(graphics, n, l2, l, true);
        graphics.setColor(this._foreground);
    }

    private void _fillPlot() {
        super.fillPlot();
    }
}

