% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsctg.R
\name{hsctg}
\alias{hsctg}
\title{Homogeneous segmentation function with both categorical and continous variables.}
\usage{
hsctg(start = "SLK.start", end = "SLK.end", var = "deflection",
             data, method = "shs", range = NULL, by.ctg = NULL)
}
\arguments{
\item{start}{A character of start location name of a spatial line.}

\item{end}{A character of end location name of a spatial line.}

\item{var}{A character or a character vector of variable names,
such as a road pavement performance indicator.}

\item{data}{A data frame of a dataset.}

\item{method}{A character of homogeneous segmentation method.
Available methods include "shs", "cda" and "mcv".}

\item{range}{A vector of segment length threshold.}

\item{by.ctg}{A vector of categorical variable names.}
}
\description{
Homogeneous segmentation function with both categorical and continous variables.
}
\examples{
testdata <- tsdwa[1:300,]
hc1 <- hsctg(start = "SLK.start", end = "SLK.end", var = c("Curvature", "Deflection", "BLI"),
          testdata, method = "shs", range = c(0.1, 0.5), by.ctg = c("SurfType", "PvtType"))

}
