% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessoryFunctions.R
\name{checkAlignType}
\alias{checkAlignType}
\title{Ensure that AlignType Values are Valid}
\usage{
checkAlignType(alignType)
}
\arguments{
\item{alignType}{A vector of character values specifying sequence alignment types to be used for a function.}
}
\value{
A character vector that includes only allowed 'alignType' values.
}
\description{
Evaluates 'alignType' values to ensure that only "prot", "nuc", "codon" and "gen" are passed to downstream functions. If any other values are entered, a message describing excluded values is generated. If no valid 'alignType' values are are present, an error is generated, and any calling function is ended.
}
\examples{
checkAlignType(c("nuc","prot","gDNA")) 

}
