\name{auto}
\alias{auto}

\title{A motor insurance dataset}
\usage{
data(auto)
}

\description{
The motor insurance dataset is originially retrieved from the SAS Enterprise Miner database. The included dataset is generated by re-organization and transformation as described in Qian et al. (2013). 
}

\details{ This data set contains 2812 policy samples 
 with 56 predictors. See Qian et al. (2013) for a detailed description of the generation of these predictors. The response is the aggregate claim loss (in thousand dollars). The predictors are expanded from the following original variables:
   \describe{
    \item{\code{CAR_TYPE}:}{car type, 6 categories}
    \item{\code{JOBCLASS}:}{job class, 8 categories}
    \item{\code{MAX_EDUC}:}{education level, 5 categories}
    \item{\code{KIDSDRIV}:}{number of children passengers}
    \item{\code{TRAVTIME}:}{time to travel from home to work}
    \item{\code{BLUEBOOK}:}{car value}
    \item{\code{NPOLICY}:}{number of policies}
    \item{\code{MVR_PTS}:}{motor vehicle record point}
    \item{\code{AGE}:}{driver age}
    \item{\code{HOMEKIDS}:}{number of children at home}
    \item{\code{YOJ}:}{years on job}
    \item{\code{INCOME}:}{income}
    \item{\code{HOME_VAL}:}{home value}
    \item{\code{SAMEHOME}:}{years in current address}
    \item{\code{CAR_USE}:}{whether the car is for commercial use}
    \item{\code{RED_CAR}:}{whether the car color is red}
    \item{\code{REVOLKED}:}{whether the driver's license was revoked in the past}
    \item{\code{GENDER}:}{gender}
    \item{\code{MARRIED}:}{whether married}
    \item{\code{PARENT1}:}{whether a single parent}
    \item{\code{AREA}:}{whether the driver lives in urban area}
    }
}

\value{
A list with the following elements:
  \item{x}{ a [2812 x 56] matrix giving 2812 policy records with 56 predictors}
  \item{y}{ the aggregate claim loss}
}



\references{
Yip, K. C. H. and Yau, K. K. W. (2005), ``On Modeling Claim Frequency Data In General Insurance With Extra Zeros'', \emph{Insurance: Mathematics and Economics} 36, 153-163. \cr

Zhang, Y (2013). ``\code{cplm}: Compound Poisson Linear Models''. A vignette for R package \code{cplm}. Available from \url{http://cran.r-project.org/web/packages/cplm}\cr

Qian, W., Yang, Y., Yang, Y. and Zou, H. (2013), ``Tweedie's Compound
    Poisson Model With Grouped Elastic Net,'' submitted to \emph{Journal of Computational and Graphical Statistics}.
}



\examples{
# load HDtweedie library
library(HDtweedie)

# load data set
data(auto)

# how many samples and how many predictors ?
dim(auto$x)

# repsonse y
auto$y
}


\keyword{datasets}
