% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_prep.R
\name{output_prep}
\alias{output_prep}
\title{Prepares output with HDX-MS data for publications}
\usage{
output_prep(filepath, output_name, states, replicates, times, percent = FALSE)
}
\arguments{
\item{filepath}{filepath to the input file. Input file is All_results table from HDX_Examiner, where all the fields are marked for export.}

\item{output_name}{Name of output file. It has to be csv file}

\item{states}{function allows to choose what states should be used for analysis. Default all states are used.}

\item{replicates}{number of replicates to be used in analysis. The function takes number of replicates up to specified number. If no argument provided number maximal common number of replicates it used.}

\item{times}{lists the deuteration times to be used in analysis. Default all states used.}

\item{percent}{return either uptake or percent deuteration, default=FALSE, return uptake}
}
\value{
Returns&saves data.frame in format that is accepted for the publications.
}
\description{
Format prepared based of example from:
Masson, G.R., Burke, J.E., Ahn, N.G. et al. Recommendations for performing, interpreting and reporting hydrogen deuterium exchange mass spectrometry (HDX-MS) experiments. Nat Methods 16, 595–602 (2019). https://doi.org/10.1038/s41592-019-0459-y
It generates csv file in format ready for publication of the data.
}
\examples{
\donttest{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
output_prep(filepath=file_nm, output_name=tempfile())
}
}
