package de.fhg.iais.kd.gridr.interfaces;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.StreamGobbler;


public class SshDeleteRemFile {
	private String hostname=null;
	private String username=null;
	private Connection conn=null;
	private String keyPath = null;
	
	public SshDeleteRemFile(String hostname, String username, String key){
		this.hostname=hostname;
		this.username=username;
		keyPath=key;
	}
	//TODO class not needed
	/**
	 * connects to hostname
	 * @return
	 */
	public boolean connect(){
		conn = new Connection(hostname);

		try
		{
			conn.connect();

			if(conn.isAuthMethodAvailable(username, "publickey")){
				File key = new File(keyPath);

				if (key.exists())
				{
					boolean res = conn.authenticateWithPublicKey(username, key, null);

					if (res != true){
						System.err.println("Authentication failed. Please setup a login with RSA Keys and without password");
						return(false);
					}
					return(true);
				}
			}
			return(false);
			
		}
	catch(Exception e)
		{
			e.printStackTrace();
			return(false);
		}
	}
	
	/**
	 * executes the command msg on remote side
	 * @param msg	Message to execute
	 * @throws Exception
	 */
	public void send(String msg)throws Exception {
    	  Session sess = conn.openSession();
			
		sess.execCommand(msg);


		InputStream stdout = new StreamGobbler(sess.getStdout());
		InputStream stderr = new StreamGobbler(sess.getStderr());
		
		BufferedReader br = new BufferedReader(new InputStreamReader(stdout));
		BufferedReader stderrReader = new BufferedReader(new InputStreamReader(stderr));
		
		while (true)
		{
			String line = br.readLine();
			if (line == null)
				break;
			System.out.println(line);
		}
		
		boolean begin=true;
		while (true)
		{
			String line = stderrReader.readLine();
			if(begin && line!=null){
				System.err.println("Here is the output from stderr:");
				begin=false;
			}
			if (line == null)
				break;
			System.err.println(line);
		}

		sess.close();
	  }
	
	/**
	 * closes the connection
	 */
	public void close()
	{
		/* Close the connection */

		conn.close();
	}
	
	/**
	 * deletes a file via Trilead Ssh with the use of an authentication Key
	 * @param args[0] ip
					args[1] username
					args[2] Path to ssh AuthKey
					args[3] localDir where to Download
					args[4] remoteDir
					args[5] file to delete
					
	 */
	public static void main(String[] args)
	{	
		if(args.length==6){
		  try {
			SshDownload client = new SshDownload(args[0], args[1], args[2]);
			client.connect();
			client.send("rm "+args[5]);
			client.close();
		  } catch (Exception e) {
			  e.printStackTrace();
		  }
		}
		else
			System.out.println("Wrong usage of SshDeleteRemFiles.");
		
	}
		
}
