% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{L_mult}
\alias{L_mult}
\title{Multiply approximate Cholesky by a vector}
\usage{
L_mult(Linv, z, NNarray)
}
\arguments{
\item{Linv}{Entries of the sparse inverse Cholesky factor,
usually the output from \code{\link{vecchia_Linv}}.}

\item{z}{the vector to be multiplied}

\item{NNarray}{A matrix of indices, usually the output from \code{\link{find_ordered_nn}}. 
Row \code{i} contains the indices
of the observations that observation \code{i} conditions on. By convention,
the first element of row \code{i} is \code{i}.}
}
\value{
the product of the Cholesky factor with a vector
}
\description{
Vecchia's approximation implies a sparse approximation to the 
inverse Cholesky factor of the covariance matrix. This function
returns the result of multiplying the inverse of that matrix by a vector 
(i.e. an approximation to the Cholesky factor).
}
\examples{
n <- 2000
locs <- matrix( runif(2*n), n, 2 )
covparms <- c(2, 0.2, 0.75, 0.1)
ord <- order_maxmin(locs)
NNarray <- find_ordered_nn(locs,20)
Linv <- vecchia_Linv( covparms, "matern_isotropic", locs, NNarray )
z <- rnorm(n)
y1 <- fast_Gp_sim_Linv(Linv,NNarray,z)
y2 <- L_mult(Linv, z, NNarray)
print( sum( (y1-y2)^2 ) )
}
