% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gnrlBezierPoints}
\alias{gnrlBezierPoints}
\title{Generates a generalized Bezier line}
\usage{
gnrlBezierPoints(ctrl_points, length_out = 100L)
}
\arguments{
\item{ctrl_points}{The ctrl_points for the bezier control points. This should
either be a \code{matrix} or a \code{data.frame}.}

\item{length_out}{The length of the return points, i.e. how fine
detailed the points should be.}
}
\description{
This is a general form of bezier line that can be used for cubic, quadratic,
and more advanced Bezier lines.
}
\examples{
library(grid)
grid.newpage()
l <- gnrlBezierPoints(data.frame(x = c(.1, -.1, .7, 1, 1, 0.1),
                                 y = c(.9, 0, 1, .8, .4, .1)),
                      length_out = 100)
grid.lines(l[,1], l[,2], gp=gpar(col="#550000", lwd = 4))

out_sizes <- 4:20
clrs <- colorRampPalette(c("orange", "darkblue"))(length(out_sizes))
for (i in out_sizes){
   l <- gnrlBezierPoints(data.frame(x = c(.1, -.1, .7, 1, 1, 0.1),
                                    y = c(.9, 0, 1, .8, .4, .1)),
                         length_out = i)
   grid.lines(l[,1], l[,2],
   gp=gpar(col=clrs[which(i == out_sizes)]))
}
}
