% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier.R
\name{outlier}
\alias{outlier}
\title{R function for univariate outliers detection}
\usage{
outlier(x, method = "mean", addthres = TRUE)
}
\arguments{
\item{x}{Vector storing the data.}

\item{method}{Outliers identification method, either "mean" (default), "median", or "boxplot".}

\item{addthres}{Takes FALSE or TRUE (default) if user does not want or does want some threshold
lines be added to the returned chart.}
}
\value{
The function also returns a list containing information about the
chosen method, the mid-point, lower and upper boundaries where non-outlying observations are
expected to fall, total number of outlying observations, and a dataframe listing the observations
and indicating which is considered outlier.\cr
In the charts, the outlying observations are flagged with their ID number.
}
\description{
The function allows to perform univariate outliers detection using three different methods. These
methods are those described in:\cr Wilcox R R, "Fundamentals of Modern Statistical Methods:
Substantially Improving Power and Accuracy", Springer 2010 (2nd edition), pages 31-35.\cr
}
\details{
Two of
the three methods are robust, and are therefore less prone to the masking effect.\cr
(1) With the
mean-based method, an observation is considered outlier if the absolute difference between that
observation and the sample mean is more than 2 Standard Deviations away (in either direction)
from the mean. In the plot returned by the function, the central reference line is indicating the
mean value, while the other two are set at  \eqn{mean-2*SD and mean+2*SD}.\cr

(2) The median-based
method considers an observation as being outlier if the absolute difference between the
observation and the sample median is larger than the Median Absolute Deviation divided by 0.6745.
In this case, the central reference line is set at the median, while the other two are set at
\eqn{median-2*MAD/0.6745} and \eqn{median+2*MAD/0.6745}.\cr

(3) The boxplot-based method considers an
observation as being an outlier if it is either smaller than the 1st Quartile minus 1.5 times the
InterQuartile Range, or larger than the 3rd Quartile minus 1.5 times the InterQuartile Range. In
the plot, the central reference line is set at the median, while the other two are set at
\eqn{1Q-1.5*IQR} and \eqn{3Q+1.5*IQR}.\cr
}
\examples{
# create a toy dataset
mydata <- c(2,3,4,5,6,7,8,9,50,50)

# locate outlier(s) using the median-based method
outlier(mydata, method="median", addthres=TRUE)

}
\keyword{outlier}
