% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_release_logs.R
\name{get_release_logs}
\alias{get_release_logs}
\title{Get release logs}
\usage{
get_release_logs(
  gitstats,
  since = NULL,
  until = Sys.Date() + lubridate::days(1),
  cache = TRUE,
  verbose = is_verbose(gitstats),
  progress = verbose
)
}
\arguments{
\item{gitstats}{A \code{GitStats} object.}

\item{since}{A starting date.}

\item{until}{An end date.}

\item{cache}{A logical, if set to \code{TRUE} GitStats will retrieve the last
result from its storage.}

\item{verbose}{A logical, \code{TRUE} by default. If \code{FALSE} messages and printing
output is switched off.}

\item{progress}{A logical, by default set to \code{verbose} value. If \code{FALSE} no
\code{cli} progress bar will be displayed.}
}
\value{
A data.frame.
}
\description{
Pull release logs from repositories.
}
\examples{
\dontrun{
 my_gitstats <- create_gitstats() \%>\%
  set_github_host(
    token = Sys.getenv("GITHUB_PAT"),
    orgs = c("r-world-devs", "openpharma")
  )
  get_release_logs(my_gistats, since = "2024-01-01")
}
}
