% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gitrd_utils.R
\name{gitrd.fix.dataframes}
\alias{gitrd.fix.dataframes}
\title{Fix dataframe for version issues and inflation measures (internal)}
\usage{
gitrd.fix.dataframes(df.in, inflation.index, df.inflation)
}
\arguments{
\item{df.in}{A dataframe with financial statements}

\item{inflation.index}{Set which inflation index to use for finding inflation adjusted values of all reports. Possible values: 'none' (default), 'IPCA' - main brazilian inflation index and 'dollar'.
When using 'IPCA', the base date as set as the last date found in the inflation dataset.}

\item{df.inflation}{Dataframe with inflation data}
}
\value{
The fixed data.frame
}
\description{
Fix dataframe for version issues and inflation measures (internal)
}
\examples{
#'
# get example data from RData file
my.f <- system.file('extdata/ExampleReport_Petrobras.RData', package = 'GetITRData')
load(my.f)

df.assets <- df.reports$assets[[1]]

df.assets.fixed <- gitrd.fix.dataframes(df.assets,
                                        inflation.index = 'none',
                                        df.inflation = data.frame())
}
