% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeodRegr.R
\name{intrinsic_location}
\alias{intrinsic_location}
\title{Gradient descent for location based on M-type estimators}
\usage{
intrinsic_location(
  manifold,
  y,
  estimator,
  c = NULL,
  p_tol = 1e-05,
  V_tol = 1e-05,
  max_iter = 1e+05
)
}
\arguments{
\item{manifold}{Type of manifold (\code{'euclidean'}, \code{'sphere'}, or
\code{'kendall'}).}

\item{y}{A matrix or data frame whose columns represent points on the
manifold.}

\item{estimator}{M-type estimator (\code{'l2'}, \code{'l1'}, \code{'huber'},
or \code{'tukey'}).}

\item{c}{Multiplier of \eqn{\sigma}, the square root of the variance, used in
the cutoff parameter for the \code{'huber'} and \code{'tukey'} estimators;
should be \code{NULL} for the \code{'l2'} or \code{'l1'} estimators.}

\item{p_tol}{Termination condition for the distance between consecutive
updates of \code{p}.}

\item{V_tol}{Termination condition for the distance between columns of
consecutive updates of \code{V}, parallel transported to be in the same
tangent space. Can be a vector of positive real numbers for each
independent variable or a single positive number.}

\item{max_iter}{Maximum number of gradient descent steps before ending the
algorithm.}
}
\value{
A vector representing the location estimate
}
\description{
Finds \eqn{\mathrm{argmin}_{p\in M}\sum_{i=1}^{N} \rho(d(p,y_i))} through a
gradient descent algorithm.
}
\details{
In the case of the \code{'sphere'}, an error will be raised if all points are
on a pair of antipodes.
}
\examples{
y <- matrix(runif(100, 1000, 2000), nrow = 10)
intrinsic_location('euclidean', y, 'l2')

}
\references{
Fletcher, P. T. (2013). Geodesic regression and the theory of
  least squares on Riemannian manifolds. International Journal of Computer
  Vision, 105, 171-185.

  Kim, H. J., Adluru, N., Collins, M. D., Chung, M. K., Bendin, B. B.,
  Johnson, S. C., Davidson, R. J. and Singh, V. (2014). Multivariate general
  linear models (MGLM) on Riemannian manifolds with applications to
  statistical analysis of diffusion weighted images. 2014 IEEE Conference on
  Computer Vision and Pattern Recognition, 2705-2712.

  Shin, H.-Y. and Oh H.-S. (2020). Robust Geodesic Regression.
  <arXiv:2007.04518>
}
\seealso{
\code{\link{geo_reg}}, \code{\link[RiemBase]{rbase.mean}},
  \code{\link[RiemBase]{rbase.median}}.
}
\author{
Ha-Young Shin
}
